/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.miscellaneous.util.aggregation;

import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import io.github.devlibx.miscellaneous.util.aggregation.TimeWindowDataAggregation;
import io.github.devlibx.miscellaneous.util.aggregation.TimeWindowDataAggregationHelper;
import org.joda.time.DateTime;

public class Demo {
    public static void main(String[] args) {
        TimeWindowDataAggregation aggregation = new TimeWindowDataAggregation();
        TimeWindowDataAggregationHelper<InputObject> helper = new TimeWindowDataAggregationHelper<InputObject>(TimeWindowDataAggregationHelper.Config.builder().dayHourAggregationWindow(31).hourAggregationWindow(24).minuteAggregationWindow(60).build());
        TimeWindowDataAggregationHelper.IAggregationUpdater<InputObject> updater = (data, key, event) -> {
            long existingValue = data.getLong(key) == null ? 0L : data.getLong(key);
            data.put((Object)key, (Object)(existingValue + 1L));
        };
        DateTime now = DateTime.now();
        InputObject inputObject = InputObject.builder().orderId("1").timestamp(now).build();
        helper.process(aggregation, now, inputObject, inputObject.timestamp, updater);
        System.out.println(JsonUtils.asJson((Object)aggregation));
        now = DateTime.now();
        inputObject = InputObject.builder().orderId("1").timestamp(now).build();
        helper.process(aggregation, now, inputObject, inputObject.timestamp, updater);
        System.out.println(JsonUtils.asJson((Object)aggregation));
        now = DateTime.now();
        inputObject = InputObject.builder().orderId("1").timestamp(now).build();
        helper.process(aggregation, now, inputObject, inputObject.timestamp, updater);
        System.out.println(JsonUtils.asJson((Object)aggregation));
    }

    public static class InputObject {
        private String orderId;
        DateTime timestamp;

        InputObject(String orderId, DateTime timestamp) {
            this.orderId = orderId;
            this.timestamp = timestamp;
        }

        public static InputObjectBuilder builder() {
            return new InputObjectBuilder();
        }

        public String getOrderId() {
            return this.orderId;
        }

        public DateTime getTimestamp() {
            return this.timestamp;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public void setTimestamp(DateTime timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputObject)) {
                return false;
            }
            InputObject other = (InputObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$orderId = this.getOrderId();
            String other$orderId = other.getOrderId();
            if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
                return false;
            }
            DateTime this$timestamp = this.getTimestamp();
            DateTime other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $orderId = this.getOrderId();
            result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
            DateTime $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            return result;
        }

        public String toString() {
            return "Demo.InputObject(orderId=" + this.getOrderId() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public static class InputObjectBuilder {
            private String orderId;
            private DateTime timestamp;

            InputObjectBuilder() {
            }

            public InputObjectBuilder orderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            public InputObjectBuilder timestamp(DateTime timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public InputObject build() {
                return new InputObject(this.orderId, this.timestamp);
            }

            public String toString() {
                return "Demo.InputObject.InputObjectBuilder(orderId=" + this.orderId + ", timestamp=" + this.timestamp + ")";
            }
        }
    }
}

