/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.miscellaneous.util.aggregation;

import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.miscellaneous.util.aggregation.TimeWindowDataAggregationHelper;
import java.util.HashSet;

public interface CustomAggregationUpdater {

    public static class StringAppender
    implements TimeWindowDataAggregationHelper.IAggregationUpdater<StringObjectMap> {
        private final String newString;

        public StringAppender(String newString) {
            this.newString = newString;
        }

        @Override
        public void update(StringObjectMap data, String key, StringObjectMap event) {
            String existingValue = data.getString(key) == null ? "" : data.getString(key);
            HashSet<String> merchants = new HashSet<String>();
            for (String s : existingValue.split(",")) {
                if (Strings.isNullOrEmpty((String)s)) continue;
                merchants.add(s);
            }
            merchants.add(this.newString);
            data.put((Object)key, (Object)String.join((CharSequence)",", merchants));
        }
    }

    public static class AddValue
    implements TimeWindowDataAggregationHelper.IAggregationUpdater<StringObjectMap> {
        private final long value;

        public AddValue(long value) {
            this.value = value;
        }

        @Override
        public void update(StringObjectMap data, String key, StringObjectMap event) {
            long existingValue = data.getLong(key) == null ? 0L : data.getLong(key);
            data.put((Object)key, (Object)(existingValue + this.value));
        }
    }

    public static class IncrementCounter
    implements TimeWindowDataAggregationHelper.IAggregationUpdater<StringObjectMap> {
        @Override
        public void update(StringObjectMap data, String key, StringObjectMap event) {
            long existingValue = data.getLong(key) == null ? 0L : data.getLong(key);
            data.put((Object)key, (Object)(existingValue + 1L));
        }
    }
}

