/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.miscellaneous.util.aggregation;

import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.miscellaneous.util.aggregation.TimeWindowDataAggregationHelper;
import java.util.HashSet;

public interface CustomAggregationUpdater {

    public static class StringAppender
    implements TimeWindowDataAggregationHelper.IAggregationUpdater<StringObjectMap> {
        private final String newString;
        private final String separator;

        public StringAppender(String newString, String separator) {
            this.newString = newString;
            this.separator = separator;
        }

        @Override
        public void update(StringObjectMap data, String key, StringObjectMap event) {
            String existingValue = data.getString(key) == null ? "" : data.getString(key);
            HashSet<String> merchants = new HashSet<String>();
            for (String s : existingValue.split(this.separator)) {
                if (Strings.isNullOrEmpty((String)s)) continue;
                merchants.add(s);
            }
            merchants.add(this.newString);
            data.put((Object)key, (Object)String.join((CharSequence)this.separator, merchants));
        }
    }

    public static class AddDoubleValue
    implements TimeWindowDataAggregationHelper.IAggregationUpdater<StringObjectMap> {
        private final double value;

        public AddDoubleValue(double value) {
            this.value = value;
        }

        @Override
        public void update(StringObjectMap data, String key, StringObjectMap event) {
            double existingValue = data.getDouble(key) == null ? 0.0 : data.getDouble(key);
            data.put((Object)key, (Object)(existingValue + this.value));
        }
    }

    public static class AddValue
    implements TimeWindowDataAggregationHelper.IAggregationUpdater<StringObjectMap> {
        private final long value;

        public AddValue(long value) {
            this.value = value;
        }

        @Override
        public void update(StringObjectMap data, String key, StringObjectMap event) {
            long existingValue = data.getLong(key) == null ? 0L : data.getLong(key);
            data.put((Object)key, (Object)(existingValue + this.value));
        }
    }

    public static class DecrementCounter
    implements TimeWindowDataAggregationHelper.IAggregationUpdater<StringObjectMap> {
        private final boolean skip;
        private final long threshold;

        public DecrementCounter(boolean skip, long threshold) {
            this.skip = skip;
            this.threshold = threshold;
        }

        @Override
        public void update(StringObjectMap data, String key, StringObjectMap event) {
            long existingValue;
            long l = existingValue = data.getLong(key) == null ? 0L : data.getLong(key);
            if (!this.skip || existingValue > this.threshold) {
                data.put((Object)key, (Object)(existingValue - 1L));
            }
        }
    }

    public static class IncrementCounter
    implements TimeWindowDataAggregationHelper.IAggregationUpdater<StringObjectMap> {
        @Override
        public void update(StringObjectMap data, String key, StringObjectMap event) {
            long existingValue = data.getLong(key) == null ? 0L : data.getLong(key);
            data.put((Object)key, (Object)(existingValue + 1L));
        }
    }
}

