/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit;

import com.uopen.cryptionkit.Op;
import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.UCipher;
import com.uopen.cryptionkit.USignature;
import com.uopen.cryptionkit.core.AesCipher;
import com.uopen.cryptionkit.core.DesCipher;
import com.uopen.cryptionkit.core.DsaSignature;
import com.uopen.cryptionkit.core.HmacSHA1Cipher;
import com.uopen.cryptionkit.core.HmacSHA256Cipher;
import com.uopen.cryptionkit.core.Md5Signature;
import com.uopen.cryptionkit.core.RsaPrivateCipher;
import com.uopen.cryptionkit.core.RsaPublicCipher;
import com.uopen.cryptionkit.core.Sm2Cipher;
import com.uopen.cryptionkit.core.Sm3Signature;
import com.uopen.cryptionkit.core.Sm4Cipher;
import com.uopen.cryptionkit.core.TripleDesCipher;
import com.uopen.cryptionkit.key.KeyCreator;
import com.uopen.cryptionkit.key.KeyCreatorDefault;
import com.uopen.cryptionkit.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UEncryptionManager {
    private static KeyCreator keyCreator;
    private UCipher cipher;
    private USignature signature;
    private static Map<String, Object> objectCache;

    public static UEncryptionManager getInstance() {
        return EncryptionHelper.INSTANCE.getEncryptionHelper();
    }

    public static void initKey(KeyCreator mKeyCreator) {
        keyCreator = mKeyCreator;
    }

    public void checkKey() {
        if (keyCreator == null) {
            keyCreator = KeyCreatorDefault.DEFAULT();
        }
    }

    public UCipher getCipher(Class clazz) throws Exception {
        this.cipher = (UCipher)objectCache.get(clazz.getName());
        if (this.cipher == null) {
            Object tmp = clazz.newInstance();
            if (tmp instanceof UCipher) {
                this.cipher = (UCipher)tmp;
                objectCache.put(clazz.getName(), this.cipher);
            } else {
                throw new Exception("this class " + clazz.getName() + "not instance of " + UCipher.class.getName());
            }
        }
        return this.cipher;
    }

    public USignature getSignature(Class clazz) throws Exception {
        this.signature = (USignature)objectCache.get(clazz.getName());
        if (this.signature == null) {
            Object tmp = clazz.newInstance();
            if (tmp instanceof USignature) {
                this.signature = (USignature)clazz.newInstance();
                objectCache.put(clazz.getName(), this.signature);
            } else {
                throw new Exception("this class " + clazz.getName() + "not instance of " + USignature.class.getName());
            }
        }
        return this.signature;
    }

    public String withOneDes(String content, Op type, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getDesPass())) {
            throw new RuntimeException("Warning\uff1awe not found 'AesPass' in KeyCreator");
        }
        return this.optEncrypt(DesCipher.class, keyCreator.getDesPass(), content, type, returnDataType);
    }

    public String withAes(String content, Op type, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getAesPass())) {
            throw new RuntimeException("Warning\uff1awe not found 'AesPass' in KeyCreator");
        }
        return this.optEncrypt(AesCipher.class, keyCreator.getAesPass(), content, type, returnDataType);
    }

    public String withTripleDes(String content, Op type, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getTriplePass())) {
            throw new RuntimeException("Warning\uff1awe not found 'TriplePass' in KeyCreator");
        }
        return this.optEncrypt(TripleDesCipher.class, keyCreator.getTriplePass(), content, type, returnDataType);
    }

    public String withMd5(String content, ReturnType returnDataType) {
        return this.opSign(Md5Signature.class, content, returnDataType);
    }

    public String withHmacSha1(String content, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getHmacShaPass())) {
            throw new RuntimeException("Warning\uff1awe not found 'HmacShaPass' in KeyCreator");
        }
        return this.optEncrypt(HmacSHA1Cipher.class, keyCreator.getHmacShaPass(), content, Op.Encryption, returnDataType);
    }

    public String withHmacSh256(String content, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getHmacShaPass())) {
            throw new RuntimeException("Warning\uff1awe not found 'HmacShaPass' in KeyCreator");
        }
        return this.optEncrypt(HmacSHA256Cipher.class, keyCreator.getHmacShaPass(), content, Op.Encryption, returnDataType);
    }

    public String withRsaPrivate(String content, Op operator, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getRsaPrivatePass())) {
            throw new RuntimeException("Warning\uff1awe not found 'RsaPrivatePass' in KeyCreator");
        }
        return this.optEncrypt(RsaPrivateCipher.class, keyCreator.getRsaPrivatePass(), content, operator, returnDataType);
    }

    public String withRsaPublic(String content, Op operator, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getRsaPublicPass())) {
            throw new RuntimeException("Warning\uff1awe not found 'RsaPublicPass' in KeyCreator");
        }
        return this.optEncrypt(RsaPublicCipher.class, keyCreator.getRsaPublicPass(), content, operator, returnDataType);
    }

    public String withSm3(String content, ReturnType returnDataType) {
        return this.opSign(Sm3Signature.class, content, returnDataType);
    }

    public String withSm2PrivateKey(String content, Op operator, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getSm2PrivatePass())) {
            throw new RuntimeException("Warning\uff1awe not found 'Sm2PrivatePass' in KeyCreator");
        }
        return this.optEncrypt(Sm2Cipher.class, keyCreator.getSm2PrivatePass(), content, operator, returnDataType);
    }

    public String withSm2PublicKey(String content, Op operator, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getSm2PublicPass())) {
            throw new RuntimeException("Warning\uff1awe not found 'Sm2PrivatePass' in KeyCreator");
        }
        return this.optEncrypt(Sm2Cipher.class, keyCreator.getSm2PublicPass(), content, operator, returnDataType);
    }

    public String withSm4(String content, Op operator, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getSm4Pass())) {
            throw new RuntimeException("Warning\uff1awe not found 'Sm4Pass' in KeyCreator");
        }
        return this.optEncrypt(Sm4Cipher.class, keyCreator.getSm4Pass(), content, operator, returnDataType);
    }

    public String withDasSign(String content, ReturnType returnDataType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getDasPrivateKey())) {
            throw new RuntimeException("Warning\uff1awe not found 'DasPrivateKey' in KeyCreator");
        }
        return this.opSignByKey(DsaSignature.class, keyCreator.getDasPrivateKey(), content, returnDataType);
    }

    public Boolean withDasVerify(String data, String sign, ReturnType returnType) {
        this.checkKey();
        if (StringUtils.isNull(keyCreator.getDasPublicKey())) {
            throw new RuntimeException("Warning\uff1awe not found 'DasPublicKey' in KeyCreator");
        }
        return this.verify(DsaSignature.class, keyCreator.getDasPublicKey(), sign, data, returnType);
    }

    public String optEncrypt(Class clazz, String key, String content, Op type, ReturnType returnDataType) {
        String tempStr = null;
        try {
            this.cipher = this.getCipher(clazz);
            this.cipher.setReturnDataType(returnDataType);
            switch (type) {
                case Decrypt: {
                    tempStr = this.cipher.decode(key, content);
                    break;
                }
                case Encryption: {
                    tempStr = this.cipher.encode(key, content);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempStr;
    }

    public String opSign(Class clazz, String content, ReturnType returnDataType) {
        try {
            this.signature = this.getSignature(clazz);
            this.signature.setReturnDataType(returnDataType);
            return this.signature.signToString(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String opSignByKey(Class clazz, String key, String content, ReturnType returnDataType) {
        try {
            this.signature = this.getSignature(clazz);
            this.signature.setReturnDataType(returnDataType);
            return this.signature.signByKey(key, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean verify(Class clazz, String key, String sign, String content, ReturnType returnDataType) {
        try {
            this.signature = this.getSignature(clazz);
            this.signature.setReturnDataType(returnDataType);
            return this.signature.verify(key, content, sign);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    public static KeyCreator getKeyCreator() {
        return keyCreator;
    }

    static {
        objectCache = new ConcurrentHashMap<String, Object>();
    }

    public static enum EncryptionHelper {
        INSTANCE;

        private UEncryptionManager encryptionManager = new UEncryptionManager();

        public UEncryptionManager getEncryptionHelper() {
            return this.encryptionManager;
        }
    }
}

