/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.UCipher;
import com.uopen.cryptionkit.utils.UUtils;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public class AesCipher
implements UCipher {
    private ReturnType returnType = ReturnType.TYPE_HEX;

    @Override
    public void setReturnDataType(ReturnType mReturnType) {
        this.returnType = mReturnType;
    }

    @Override
    public String encode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.encodeToHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.encodeToBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String decode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.decodeByHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.decodeByBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.decode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String encodeToBase64(String key, String content) throws Exception {
        byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return new String(Base64.encode((byte[])values), Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String encodeToHexString(String key, String content) throws Exception {
        byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return UUtils.byteArrayToHexString(values);
        }
        return null;
    }

    @Override
    public byte[] encode(String key, byte[] content) throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(key.getBytes());
        keygen.init(128, random);
        SecretKey original_key = keygen.generateKey();
        byte[] raw = original_key.getEncoded();
        SecretKeySpec _key = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, _key);
        byte[] byte_AES = cipher.doFinal(content);
        return byte_AES;
    }

    @Override
    public byte[] decode(String key, byte[] content) throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(key.getBytes());
        keygen.init(128, random);
        SecretKey original_key = keygen.generateKey();
        byte[] raw = original_key.getEncoded();
        SecretKeySpec _key = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, _key);
        byte[] byte_decode = cipher.doFinal(content);
        return byte_decode;
    }

    @Override
    public String decodeByBase64(String key, String contentBase64) throws Exception {
        byte[] values = this.decode(key, Base64.decode((String)contentBase64));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String decodeByHexString(String key, String contentHex) throws Exception {
        byte[] values = this.decode(key, UUtils.hexStringToByteArray(contentHex));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }
}

