/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.UCipher;
import com.uopen.cryptionkit.core.RsaPrivateCipher;
import com.uopen.cryptionkit.utils.UUtils;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import org.bouncycastle.util.encoders.Base64;

public class RsaPublicCipher
implements UCipher {
    private static final String ALGORITHM = "RSA";
    private ReturnType returnType = ReturnType.TYPE_HEX;

    @Override
    public void setReturnDataType(ReturnType mReturnType) {
        this.returnType = mReturnType;
    }

    @Override
    public String encode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.encodeToHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.encodeToBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String decode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.decodeByHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.decodeByBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.decode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public byte[] encode(String base64key, byte[] content) throws Exception {
        RSAPublicKey rsaPublicKey = RsaPrivateCipher.KeyPairHelper.getPublicKey(base64key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, rsaPublicKey);
        int splitLength = rsaPublicKey.getModulus().bitLength() / 8 - 11;
        byte[][] arrays = UUtils.splitBytes(content, splitLength);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (byte[] array : arrays) {
            byteArrayOutputStream.write(cipher.doFinal(array));
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String encodeToBase64(String base64key, String content) throws Exception {
        byte[] values = this.encode(base64key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return new String(Base64.encode((byte[])values), Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String encodeToHexString(String base64key, String content) throws Exception {
        byte[] values = this.encode(base64key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return UUtils.byteArrayToHexString(values);
        }
        return null;
    }

    @Override
    public byte[] decode(String base64key, byte[] content) throws Exception {
        RSAPublicKey rsaPublicKey = RsaPrivateCipher.KeyPairHelper.getPublicKey(base64key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, rsaPublicKey);
        int splitLength = rsaPublicKey.getModulus().bitLength() / 8;
        byte[][] arrays = UUtils.splitBytes(content, splitLength);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (byte[] array : arrays) {
            byteArrayOutputStream.write(cipher.doFinal(array));
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String decodeByBase64(String base64key, String contentBase64) throws Exception {
        byte[] values = this.decode(base64key, Base64.decode((String)contentBase64));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String decodeByHexString(String base64key, String contentHex) throws Exception {
        byte[] values = this.decode(base64key, UUtils.hexStringToByteArray(contentHex));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }
}

