/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.utils;

import com.uopen.cryptionkit.utils.StringUtils;
import com.uopen.cryptionkit.utils.UUIDUtils;
import com.uopen.cryptionkit.utils.UUtils;
import java.io.File;
import java.io.FileWriter;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RsaKeyHelper {
    private static KeyPairGenerator keyPairGenerator = null;
    private static KeyFactory keyFactory = null;
    private static KeyPair keyPair = null;
    private static final String ALGORITHM = "RSA";
    private static final int KEY_SIZE = 1024;

    public static RSAPublicKey getPublicKey(byte[] keyBytes) {
        if (keyBytes == null) {
            return null;
        }
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
            return (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RSAPrivateKey getPrivateKey(byte[] privateKey) {
        try {
            if (privateKey == null) {
                return null;
            }
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey);
            return (RSAPrivateKey)keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized KeyPass generateKeyPair() {
        try {
            keyPairGenerator.initialize(1024, new SecureRandom(UUIDUtils.getUUID().getBytes()));
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        String publicKeyString = UUtils.byteToHex(rsaPublicKey.getEncoded());
        String privateKeyString = UUtils.byteToHex(rsaPrivateKey.getEncoded());
        KeyPass keyPass = new KeyPass();
        keyPass.setPublicKeyHex(publicKeyString);
        keyPass.setPrivateKeyHex(privateKeyString);
        return keyPass;
    }

    static {
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
            keyFactory = KeyFactory.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static class KeyPass {
        private String publicKeyHex;
        private String privateKeyHex;

        public String getPublicKeyHex() {
            return this.publicKeyHex;
        }

        public void setPublicKeyHex(String publicKeyHex) {
            this.publicKeyHex = publicKeyHex;
        }

        public String getPrivateKeyHex() {
            return this.privateKeyHex;
        }

        public void setPrivateKeyHex(String privateKeyHex) {
            this.privateKeyHex = privateKeyHex;
        }

        public void saveToFile(String privateKeyFilePath, String publicKeyFilePath) throws Exception {
            if (StringUtils.isNull(privateKeyFilePath) || StringUtils.isNull(publicKeyFilePath) || this.publicKeyHex == null || this.privateKeyHex == null) {
                throw new Exception("error:saveToFile function args invalid ?");
            }
            File privateKeyFile = new File(privateKeyFilePath);
            File publicKeyFile = new File(publicKeyFilePath);
            try {
                privateKeyFile.createNewFile();
                publicKeyFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FileWriter fileWriterPrivate = new FileWriter(privateKeyFile);
            fileWriterPrivate.write(this.privateKeyHex);
            fileWriterPrivate.flush();
            fileWriterPrivate.close();
            FileWriter fileWriterPublic = new FileWriter(publicKeyFile);
            fileWriterPublic.write(this.publicKeyHex);
            fileWriterPublic.flush();
            fileWriterPublic.close();
        }
    }
}

