/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.utils;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.utils.StringUtils;
import com.uopen.cryptionkit.utils.UUtils;
import java.io.File;
import java.io.FileWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

public class DSAKeyHelper {
    public static final String KEY_ALGORITHM = "DSA";
    public static final int KEY_SIZE = 1024;

    public static KeyPass genKeyPair(String seed, ReturnType returnType) {
        try {
            KeyPairGenerator keygen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.setSeed(seed.getBytes());
            keygen.initialize(1024, secureRandom);
            keygen.genKeyPair();
            KeyPair keys = keygen.genKeyPair();
            PrivateKey privateKey = keys.getPrivate();
            PublicKey publicKey = keys.getPublic();
            KeyPass keyPass = new KeyPass();
            if (returnType.equals((Object)ReturnType.TYPE_BASE64)) {
                keyPass.setPublicKey(UUtils.convertToBase64(publicKey.getEncoded()));
                keyPass.setPrivateKey(UUtils.convertToBase64(privateKey.getEncoded()));
            } else {
                keyPass.setPublicKey(UUtils.byteArrayToHexString(publicKey.getEncoded()));
                keyPass.setPrivateKey(UUtils.byteArrayToHexString(privateKey.getEncoded()));
            }
            return keyPass;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            KeyPass keyPass = DSAKeyHelper.genKeyPair("AKJSH71O)(*75S", ReturnType.TYPE_BASE64);
            System.out.println("pri:" + keyPass.getPrivateKey());
            System.out.println("pub:" + keyPass.getPublicKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class KeyPass {
        private String publicKey;
        private String privateKey;

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public void saveToFile(String privateKeyFilePath, String publicKeyFilePath) throws Exception {
            if (StringUtils.isNull(privateKeyFilePath) || StringUtils.isNull(publicKeyFilePath) || StringUtils.isNull(this.privateKey) || StringUtils.isNull(this.publicKey)) {
                throw new Exception("error:saveToFile function args invalid ?");
            }
            File privateKeyFile = new File(privateKeyFilePath);
            File publicKeyFile = new File(publicKeyFilePath);
            try {
                privateKeyFile.createNewFile();
                publicKeyFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FileWriter fileWriterPrivate = new FileWriter(privateKeyFile);
            fileWriterPrivate.write(this.privateKey);
            fileWriterPrivate.flush();
            fileWriterPrivate.close();
            FileWriter fileWriterPublic = new FileWriter(publicKeyFile);
            fileWriterPublic.write(this.publicKey);
            fileWriterPublic.flush();
            fileWriterPublic.close();
        }
    }
}

