/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.utils;

import com.uopen.cryptionkit.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;
import org.bouncycastle.util.encoders.Base64;

public class RsaKeyHelper {
    private static KeyPairGenerator keyPairGenerator = null;
    private static KeyFactory keyFactory = null;
    private static KeyPair keyPair = null;
    private static final String ALGORITHM = "RSA";
    private static final int KEY_SIZE = 2048;

    public static RSAPublicKey getPublicKey(byte[] keyBytes) {
        if (keyBytes == null) {
            return null;
        }
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
            return (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RSAPrivateKey getPrivateKey(byte[] privateKey) {
        try {
            if (privateKey == null) {
                return null;
            }
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey);
            return (RSAPrivateKey)keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized KeyPass generateKeyPair() {
        try {
            keyPairGenerator.initialize(2048, new SecureRandom(UUID.randomUUID().toString().getBytes()));
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        String publicKeyString = new String(Base64.encode((byte[])rsaPublicKey.getEncoded()), Charset.forName("UTF-8"));
        String privateKeyString = new String(Base64.encode((byte[])rsaPrivateKey.getEncoded()), Charset.forName("UTF-8"));
        KeyPass keyPass = new KeyPass();
        keyPass.setPublicKey(publicKeyString);
        keyPass.setPrivateKey(privateKeyString);
        return keyPass;
    }

    static {
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
            keyFactory = KeyFactory.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static class KeyPass {
        private String publicKey;
        private String privateKey;

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKeyHex) {
            this.publicKey = publicKeyHex;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKeyHex) {
            this.privateKey = privateKeyHex;
        }

        public void saveToFile(String privateKeyFilePath, String publicKeyFilePath) throws Exception {
            if (StringUtils.isNull(privateKeyFilePath) || StringUtils.isNull(publicKeyFilePath) || this.publicKey == null || this.privateKey == null) {
                throw new Exception("error:saveToFile function args invalid ?");
            }
            File privateKeyFile = new File(privateKeyFilePath);
            File publicKeyFile = new File(publicKeyFilePath);
            try {
                privateKeyFile.createNewFile();
                publicKeyFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FileWriter fileWriterPrivate = new FileWriter(privateKeyFile);
            fileWriterPrivate.write(this.privateKey);
            fileWriterPrivate.flush();
            fileWriterPrivate.close();
            FileWriter fileWriterPublic = new FileWriter(publicKeyFile);
            fileWriterPublic.write(this.publicKey);
            fileWriterPublic.flush();
            fileWriterPublic.close();
        }
    }
}

