/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LoggerBridge;

public class BambooBuildServerData
extends BuildServerDataProvider {
    BambooBuildServerData(LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("bamboo_buildKey") || env.containsKey("bamboo.buildKey") || env.containsKey("BAMBOO_BUILDKEY");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = Optional.ofNullable((String)this.env.get("bamboo.buildNumber")).orElseGet(() -> this.env.getOrDefault("BAMBOO_BUILDNUMBER", ""));
        this.maybePut(properties, "build.number", () -> buildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedKey = null;
        String environmentBasedBranch = null;
        for (String envKey : Arrays.asList("bamboo.planRepository.branchName", "bamboo.planRepository.<position>.branchName", "BAMBOO_PLANREPOSITORY_BRANCH")) {
            environmentBasedBranch = (String)this.env.get(envKey);
            if (environmentBasedBranch == null) continue;
            environmentBasedKey = envKey;
            break;
        }
        this.log.info("Using environment variable based branch name. {} = {}", (Object)environmentBasedKey, (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

