/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.context.impl.module;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.brijframework.container.Container;
import org.brijframework.container.module.ModuleContainer;
import org.brijframework.context.Context;
import org.brijframework.context.impl.AbstractContext;
import org.brijframework.context.impl.Stages;
import org.brijframework.context.module.ModuleContext;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.support.util.SupportUtil;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.reflect.MethodUtil;

public abstract class AbstractModuleContext
extends AbstractContext
implements ModuleContext {
    private ConcurrentHashMap<Object, ModuleContainer> cache = new ConcurrentHashMap();
    private Context context;
    private LinkedHashSet<Class<? extends ModuleContainer>> classList = new LinkedHashSet();

    @Override
    public void initialize(Context context) {
        this.context = context;
    }

    @Override
    public Context getParent() {
        return this.context;
    }

    public ConcurrentHashMap<Object, ModuleContainer> getContainers() {
        return this.cache;
    }

    public void start() {
        LoggerConsole.screen((String)("ModuleContext -> " + this.getClass().getSimpleName()), (String)("Starting to lunch the module context for " + this.getClass().getSimpleName()));
        Stages stages = this.getStages();
        switch (stages) {
            case INIT: {
                this.init();
                this.setStages(Stages.LOAD);
            }
            case LOAD: {
                this.load();
                this.setStages(Stages.READY);
            }
            case READY: {
                this.ready();
                this.setStages(Stages.START);
            }
        }
        LoggerConsole.screen((String)("ModuleContext -> " + this.getClass().getSimpleName()), (String)("Started to lunch the module context for " + this.getClass().getSimpleName()));
    }

    private void ready() {
        if (Stages.START.equals((Object)this.getStages())) {
            System.err.println("Context already stoped.");
            return;
        }
        if (this.getClassList() == null || this.getClassList().isEmpty()) {
            System.err.println("Container register should not be empty. please register context into @Override init method for :" + this.getClass().getSimpleName());
            return;
        }
        LoggerConsole.screen((String)("ModuleContext -> " + this.getClass().getSimpleName()), (String)"Ready container for module container to lunch the related factories");
        SupportUtil.getDepandOnSortedModuleContainerList(this.getClassList()).forEach(container -> this.loadContainer((Class<? extends ModuleContainer>)container));
    }

    public void stop() {
        if (Stages.STOPED.equals((Object)this.getStages())) {
            System.err.println("Context already stoped.");
            return;
        }
        if (this.getClassList() == null || this.getClassList().isEmpty()) {
            System.err.println("Container register should not be empty. please register context into @Override init method for :" + this.getClass().getSimpleName());
            return;
        }
        SupportUtil.getDepandOnSortedModuleContainerList(this.getClassList()).forEach(container -> this.destoryContainer((Class<? extends Container>)container));
    }

    protected void loadContainer(Class<? extends ModuleContainer> cls) {
        if (!InstanceUtil.isAssignable(cls)) {
            return;
        }
        LoggerConsole.screen((String)("ModuleContainer -> " + cls.getSimpleName()), (String)"Loading container for module container to lunch the related factories");
        if (!this.invokeFactoryMethod(cls)) {
            this.invokeInstanceMethod(cls);
        }
        LoggerConsole.screen((String)("ModuleContainer -> " + cls.getSimpleName()), (String)"Loaded container for module container to lunch the related factories");
    }

    protected boolean invokeFactoryMethod(Class<? extends ModuleContainer> cls) {
        for (Method method : MethodUtil.getAllMethod(cls)) {
            if (!method.isAnnotationPresent(SingletonFactory.class)) continue;
            try {
                ModuleContainer container = (ModuleContainer)method.invoke(null, new Object[0]);
                container.setContext((Context)this);
                container.init();
                container.loadContainer();
                this.getContainers().put(cls.getSimpleName(), container);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected void invokeInstanceMethod(Class<? extends ModuleContainer> cls) {
        try {
            ModuleContainer container = cls.newInstance();
            container.setContext((Context)this);
            container.init();
            container.loadContainer();
            this.getContainers().put(cls.getSimpleName(), container);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    protected void destoryContainer(Class<? extends Container> cls) {
        if (!InstanceUtil.isAssignable(cls)) {
            return;
        }
        Container container = (Container)this.getContainers().remove(cls.getName());
        container.clearContainer();
        System.gc();
    }

    protected LinkedHashSet<Class<? extends ModuleContainer>> getClassList() {
        if (this.classList == null) {
            this.classList = new LinkedHashSet();
        }
        return this.classList;
    }

    protected void register(Class<? extends ModuleContainer> container) {
        Assertion.notNull(container, (String)"Container should not be null.");
        this.getClassList().add(container);
    }
}

