/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.bean.context.asm;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.brijframework.bean.container.BeanContainer;
import org.brijframework.bean.context.BeanContext;
import org.brijframework.bean.definition.BeanDefinition;
import org.brijframework.bean.factories.definition.impl.BeanDefinitionFactoryImpl;
import org.brijframework.bean.factories.impl.BeanScopeFactoryImpl;
import org.brijframework.bean.factories.resource.impl.BeanResourceFactoryImpl;
import org.brijframework.bean.resource.BeanResource;
import org.brijframework.bean.scope.BeanScope;
import org.brijframework.context.impl.module.AbstractModuleContext;
import org.brijframework.support.enums.Scope;
import org.brijframework.util.factories.ReflectionFactory;
import org.brijframework.util.reflect.InstanceUtil;

public abstract class AbstractBeanContext
extends AbstractModuleContext
implements BeanContext {
    public void init() {
        try {
            ReflectionFactory.getFactory().getExternalClassList().forEach(cls -> {
                if (BeanContainer.class.isAssignableFrom((Class<?>)cls) && InstanceUtil.isAssignable((Class)cls)) {
                    this.register((Class)cls);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ReflectionFactory.getFactory().getInternalClassList().forEach(cls -> {
                if (BeanContainer.class.isAssignableFrom((Class<?>)cls) && InstanceUtil.isAssignable((Class)cls)) {
                    this.register((Class)cls);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public <T> T getBean(String name) {
        BeanDefinition definition = BeanDefinitionFactoryImpl.getFactory().find(name);
        if (definition == null) {
            return null;
        }
        String uniqueID = BeanScopeFactoryImpl.getFactory().getUniqueID(definition);
        return (T)((BeanScope)BeanScopeFactoryImpl.getFactory().getBeanScope(definition, uniqueID)).getScopeObject();
    }

    @Override
    public <T> T getBean(Class<? extends Object> beanClass) {
        BeanDefinition beanMetaData = BeanDefinitionFactoryImpl.getFactory().find(beanClass.getSimpleName());
        if (beanMetaData == null) {
            return null;
        }
        String uniqueID = BeanScopeFactoryImpl.getFactory().getUniqueID(beanMetaData);
        return (T)((BeanScope)BeanScopeFactoryImpl.getFactory().getBeanScope(beanMetaData, uniqueID)).getScopeObject();
    }

    @Override
    public <T> T getBean(String name, Class<T> beanClass) {
        BeanDefinition beanMetaData = BeanDefinitionFactoryImpl.getFactory().find(name);
        if (beanMetaData == null) {
            return null;
        }
        if (!beanClass.isAssignableFrom(beanMetaData.getOwner().getType())) {
            return null;
        }
        String uniqueID = BeanScopeFactoryImpl.getFactory().getUniqueID(beanMetaData);
        return (T)((BeanScope)BeanScopeFactoryImpl.getFactory().getBeanScope(beanMetaData, uniqueID)).getScopeObject();
    }

    public List<?> getBeanList(Class<? extends Object> beanClass) {
        ArrayList<Object> objects = new ArrayList<Object>();
        List findAll = BeanScopeFactoryImpl.getFactory().findAll(beanClass);
        if (!CollectionUtils.isEmpty(findAll)) {
            for (BeanScope beanScope : findAll) {
                objects.add(beanScope.getScopeObject());
            }
        }
        return objects;
    }

    @Override
    public List<String> getBeanNameList() {
        return BeanDefinitionFactoryImpl.getFactory().getBeanNames();
    }

    @Override
    public List<String> getBeanNameList(Class<?> beanClass) {
        return BeanDefinitionFactoryImpl.getFactory().getBeanNames(beanClass);
    }

    @Override
    public List<?> getBeanList(Scope scope) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry entry : BeanScopeFactoryImpl.getFactory().getCache().entrySet()) {
            if (!((BeanScope)entry.getValue()).getBeanDefinition().getScope().equals((Object)scope)) continue;
            list.add(((BeanScope)entry.getValue()).getScopeObject());
        }
        return list;
    }

    @Override
    public BeanResource getBeanResource(String name) {
        return (BeanResource)BeanResourceFactoryImpl.getFactory().find(name);
    }

    @Override
    public List<? extends BeanResource> getBeanResourceList(String model) {
        return BeanResourceFactoryImpl.getFactory().findAllByModel(model);
    }

    @Override
    public List<? extends BeanResource> getBeanResourceList() {
        ArrayList<BeanResource> list = new ArrayList<BeanResource>();
        for (BeanResource beanResource : BeanResourceFactoryImpl.getFactory().getCache().values()) {
            list.add(beanResource);
        }
        return list;
    }

    @Override
    public List<?> getBeanResourceNameList() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration keys = BeanResourceFactoryImpl.getFactory().getCache().keys();
        while (keys.hasMoreElements()) {
            list.add((String)keys.nextElement());
        }
        return list;
    }

    @Override
    public List<?> getBeanResourceNamesList(String model) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : BeanResourceFactoryImpl.getFactory().getCache().entrySet()) {
            if (!model.equals(((BeanResource)entry.getValue()).getModel())) continue;
            list.add((String)entry.getKey());
        }
        return list;
    }

    public List<BeanResource> getBeanResourceList(Scope scope) {
        ArrayList<BeanResource> list = new ArrayList<BeanResource>();
        for (Map.Entry entry : BeanResourceFactoryImpl.getFactory().getCache().entrySet()) {
            if (!((BeanResource)entry.getValue()).getScope().equalsIgnoreCase(scope.getName())) continue;
            list.add((BeanResource)entry.getValue());
        }
        return list;
    }

    @Override
    public BeanDefinition getBeanDefinition(String name) {
        return BeanDefinitionFactoryImpl.getFactory().find(name);
    }

    @Override
    public List<? extends BeanDefinition> getBeanDefinitionList() {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        for (BeanDefinition beanMetaData : BeanDefinitionFactoryImpl.getFactory().getCache().values()) {
            list.add(beanMetaData);
        }
        return list;
    }

    @Override
    public List<? extends BeanDefinition> getBeanDefinitionList(String model) {
        return BeanDefinitionFactoryImpl.getFactory().findAllByModel(model);
    }

    @Override
    public List<?> getBeanDefinitionNameList() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration keys = BeanDefinitionFactoryImpl.getFactory().getCache().keys();
        while (keys.hasMoreElements()) {
            list.add((String)keys.nextElement());
        }
        return list;
    }

    @Override
    public List<?> getBeanDefinitionNameList(String model) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : BeanDefinitionFactoryImpl.getFactory().getCache().entrySet()) {
            if (!model.equals(((BeanDefinition)entry.getValue()).getOwner().getId())) continue;
            list.add((String)entry.getKey());
        }
        return list;
    }

    @Override
    public List<? extends BeanDefinition> getBeanDefinitionList(Class<?> metaClass) {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        for (Map.Entry entry : BeanDefinitionFactoryImpl.getFactory().getCache().entrySet()) {
            if (!metaClass.isAssignableFrom(((BeanDefinition)entry.getValue()).getOwner().getType())) continue;
            list.add((BeanDefinition)entry.getValue());
        }
        return list;
    }

    public List<BeanDefinition> getBeanDefinitionList(Scope scope) {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        for (Map.Entry entry : BeanDefinitionFactoryImpl.getFactory().getCache().entrySet()) {
            if (!((BeanDefinition)entry.getValue()).getScope().equalsIgnoreCase(scope)) continue;
            list.add((BeanDefinition)entry.getValue());
        }
        return list;
    }
}

