/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.location;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.casting.DateUtil;
import org.brijframework.util.text.StringUtil;

public abstract class DirUtil {
    static List<File> folderList = new ArrayList<File>();
    static List<File> filelist = new ArrayList<File>();

    public static List<File> getSubDirs(File file) {
        ArrayList<File> subDirs = new ArrayList<File>();
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                DirUtil.getSubDirs(subDirs, sub);
            }
        }
        return subDirs;
    }

    public static List<File> getSubDirs(List<File> subDirs, File file) {
        if (file.isDirectory()) {
            subDirs.add(file);
            for (File sub : file.listFiles()) {
                DirUtil.getSubDirs(subDirs, sub);
            }
        }
        return subDirs;
    }

    public static boolean ensureDirExists(File dir) {
        boolean dirCreatedSuccessfully;
        if (!dir.exists() && !(dirCreatedSuccessfully = dir.mkdirs())) {
            String message = dir.getAbsolutePath() + " neither exists nor could it be created successfully";
            System.out.println(StringUtil.getCharNTimes('*', message.length() + 4));
            System.out.println("* " + message + " *");
            System.out.println(StringUtil.getCharNTimes('*', message.length() + 4));
            return false;
        }
        return true;
    }

    public static boolean isFile(File file) {
        return file.isFile();
    }

    public static boolean isFolder(File folder) {
        return folder.isDirectory();
    }

    public static File getVerifiedDir(String _dirPath) {
        Assertion.notNull(_dirPath, "this arg is required; it must not be null");
        File dir = new File(_dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static boolean createFolder(String folder) {
        Assertion.notNull(folder, "this arg is required; it must not be null");
        File logDir = new File(folder);
        if (!logDir.exists()) {
            logDir.mkdirs();
            return false;
        }
        return true;
    }

    public static boolean createFolder(File logDir) {
        Assertion.notNull(logDir, "this arg is required; it must not be null");
        if (!logDir.exists()) {
            logDir.mkdirs();
            return false;
        }
        return true;
    }

    public static File getDir(String dirPath) {
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        File logDir = new File(dirPath);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        return logDir;
    }

    public static boolean createFile(String file) {
        Assertion.notNull(file, "this arg is required; it must not be null");
        String path = "";
        String fileName = "";
        if (file.contains("/")) {
            path = file.substring(0, file.lastIndexOf("/"));
            fileName = file.substring(file.lastIndexOf("/") + 1, file.length());
        } else {
            fileName = file;
        }
        boolean status = false;
        try {
            File logFile = new File(DirUtil.getDir(path), fileName);
            fileName = logFile.getAbsolutePath();
            FileWriter logWriter = new FileWriter(fileName, true);
            logWriter.write("");
            logWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    public static boolean removeFile(File file) {
        Assertion.notNull(file, "this arg is required; it must not be null");
        return file.delete();
    }

    public static boolean removeFolder(File folder) {
        Assertion.notNull(folder, "this arg is required; it must not be null");
        return folder.delete();
    }

    public static String getFilePath(String dir, String fileName) throws FileNotFoundException {
        Assertion.notNull(dir, "this arg is required; it must not be null");
        Assertion.notNull(fileName, "this arg is required; it must not be null");
        return DirUtil.getFileExists(dir, fileName).getAbsolutePath();
    }

    public static File getFileExists(String dir, String fileName) throws FileNotFoundException {
        Assertion.notNull(dir, "this arg is required; it must not be null");
        Assertion.notNull(fileName, "this arg is required; it must not be null");
        File direc = DirUtil.getDirPath(dir);
        File file = new File(direc + "/" + fileName);
        if (!file.exists()) {
            throw new FileNotFoundException(fileName + " not exists");
        }
        return file;
    }

    public static boolean getFileExists(String path) {
        Assertion.notNull(path, "this arg is required; it must not be null");
        File file = DirUtil.getPath(path);
        return file.exists();
    }

    public static void renameDir(File file) {
        Assertion.notNull(file, "this arg is required; it must not be null");
        String[] list = file.list();
        for (int i = 0; i < list.length; ++i) {
            try {
                File delfile = new File(file, list[i]);
                Calendar fileMod = Calendar.getInstance();
                fileMod.setTime(new Date(delfile.lastModified()));
                String fileName = list[i].substring(0, list[i].lastIndexOf("."));
                String extensionName = list[i].substring(list[i].lastIndexOf(".") + 1, list[i].length());
                delfile.renameTo(new File(file, fileName + "_" + DateUtil.dateTimeString(fileMod) + "." + extensionName));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteDir(File file) {
        Assertion.notNull(file, "this arg is required; it must not be null");
        String[] list = file.list();
        for (int i = 0; i < list.length; ++i) {
            try {
                File delfile = new File(file, list[i]);
                delfile.delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteAllFile(File file, int offSet) {
        Assertion.notNull(file, "this arg is required; it must not be null");
        Calendar previousDate = DateUtil.currentDate(offSet);
        System.out.println("Delete from " + file.getAbsolutePath() + " File modified before " + DateUtil.dateString(previousDate));
        String[] list = file.list();
        for (int i = 0; i < list.length; ++i) {
            try {
                File delfile = new File(file, list[i]);
                Calendar fileMod = Calendar.getInstance();
                fileMod.setTime(new Date(delfile.lastModified()));
                if (!fileMod.before(previousDate)) continue;
                delfile.delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean cleanDir(File dir) {
        Assertion.notNull(dir, "this arg is required; it must not be null");
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (File aFile : files) {
                    DirUtil.deleteDir(aFile);
                }
            }
            return true;
        }
        return false;
    }

    public static List<File> getDirFiles(String dirPath) {
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new IllegalArgumentException("The given path does not exist.");
        }
        if (DirUtil.isFile(dir)) {
            throw new IllegalArgumentException("The given path is a file. A directory is expected.");
        }
        File[] subFiles = dir.listFiles();
        if (subFiles != null && subFiles.length > 0) {
            for (File aFile : subFiles) {
                if (!aFile.isFile()) continue;
                filelist.add(aFile);
            }
        }
        return filelist;
    }

    public static List<File> getDirFolders(String dirPath) {
        File[] subFiles;
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new IllegalArgumentException("The given path does not exist.");
        }
        if (!DirUtil.isFile(dir)) {
            // empty if block
        }
        if ((subFiles = dir.listFiles()) != null && subFiles.length > 0) {
            for (File aFile : subFiles) {
                if (!aFile.isDirectory()) continue;
                folderList.add(aFile);
            }
        }
        return folderList;
    }

    public static String[] getDirFolderList(String dirPath) {
        File[] files;
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        String data = "";
        File dir = new File(dirPath);
        for (File file : files = dir.listFiles()) {
            if (!file.isDirectory()) continue;
            data = data + file.getName() + " ";
        }
        return data.split(" ");
    }

    public static String[] getFileList(String dirPath) {
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        String data = "";
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        if (files.length == 0) {
            System.err.println("The directory is empty");
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            data = data + file.getName() + " ";
        }
        return data.split(" ");
    }

    public static File getDirPath(String dirPath) throws FileNotFoundException {
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        File file = new File(dirPath);
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Directory Not found");
        }
        return file;
    }

    public static File getPath(String dirPath) {
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        return new File(dirPath);
    }

    public static File[] dirFilesWithSubDir(String dirPath) {
        File[] fList;
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        File directory = new File(dirPath);
        for (File file : fList = directory.listFiles()) {
            if (file.isFile()) {
                filelist.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            DirUtil.dirFilesWithSubDir(file.getAbsolutePath());
        }
        File[] files = new File[filelist.size()];
        int i = 0;
        for (File file : filelist) {
            files[i++] = file;
        }
        return files;
    }

    public static List<File> filesWithSubDir(String dirPath) {
        File[] fList;
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        File directory = new File(dirPath);
        ArrayList<File> list = new ArrayList<File>();
        list.add(directory);
        for (File file : fList = directory.listFiles()) {
            if (file.isFile()) {
                list.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            list.addAll(DirUtil.filesWithSubDir(file.getAbsolutePath()));
        }
        return list;
    }

    public static void deletePosDataFile(File file, int offSet) {
        Assertion.notNull(file, "this arg is required; it must not be null");
        String[] list = file.list();
        for (int i = 0; i < list.length; ++i) {
            try {
                String date = list[i].substring(list[i].length() - 14, list[i].length() - 4);
                Calendar cal = Calendar.getInstance(TimeZone.getDefault());
                Calendar dateCalOffset = DateUtil.offsetDate(cal, -offSet);
                Calendar fileDate = DateUtil.calenderForDate(date, "_", "yymmdd");
                if (fileDate.getTime().getTime() >= dateCalOffset.getTime().getTime()) continue;
                File delfile = new File(file, list[i]);
                delfile.delete();
                continue;
            }
            catch (Exception e) {
                System.out.println("Unable to delete Log Files  \r\n" + list[i]);
            }
        }
    }

    public static Vector getSubDirectories(File dir, boolean isImmediate) {
        Assertion.notNull(dir, "this arg is required; it must not be null");
        if (dir.exists()) {
            File[] dirs = dir.listFiles();
            Vector<File> subDirs = new Vector<File>();
            for (int i = 0; i < dirs.length; ++i) {
                if (!dirs[i].isDirectory()) continue;
                subDirs.add(dirs[i]);
                if (isImmediate) continue;
                subDirs.addAll(DirUtil.getSubDirectories(dirs[i], isImmediate));
            }
            return subDirs;
        }
        return null;
    }

    public static Vector getSubDirectories(File dir) {
        Assertion.notNull(dir, "this arg is required; it must not be null");
        return DirUtil.getSubDirectories(dir, false);
    }

    public static Vector getMatchingDirectoriesForAPattern(String pattern) {
        if (pattern.indexOf(42) != -1 && pattern.indexOf(63) != -1) {
            throw new RuntimeException("* and ? cannot co-exit in same pattern string: " + pattern);
        }
        if ((pattern = pattern.replace('\\', '/')).indexOf(63) != -1) {
            if (pattern.indexOf(63) < pattern.length() - 1) {
                throw new RuntimeException("? should be the last character in pattern string: " + pattern);
            }
            return DirUtil.getSubDirectories(new File(pattern.substring(0, pattern.indexOf(63))));
        }
        Vector<File> matchingDirs = new Vector<File>();
        if (pattern.indexOf(42) != -1) {
            File parentDir = new File(pattern.substring(0, pattern.indexOf(42)));
            if (parentDir.exists()) {
                Vector subDirs = DirUtil.getSubDirectories(parentDir);
                Vector baseDirTokens = DirUtil.getDirTokens(pattern);
                Enumeration enm = subDirs.elements();
                while (enm.hasMoreElements()) {
                    File dir = (File)enm.nextElement();
                    if (!DirUtil.isDirPatternMatch(baseDirTokens, DirUtil.getDirTokens(dir))) continue;
                    matchingDirs.addElement(dir);
                }
            }
        } else {
            matchingDirs.addElement(new File(pattern));
        }
        return matchingDirs;
    }

    public static Vector getMatchingDirectoriesForAPatternAlternateWay(String pattern) {
        String token;
        File dir;
        pattern = (pattern = pattern.replace('\\', '/')).endsWith("/") ? pattern.substring(0, pattern.length() - 1) : pattern;
        Vector<File> matchingParentDirs = new Vector<File>();
        StringTokenizer tokenizer = new StringTokenizer(pattern, "*");
        if (tokenizer.hasMoreTokens() && (dir = new File(token = tokenizer.nextToken())).exists()) {
            if (token.endsWith("/")) {
                matchingParentDirs.addAll(DirUtil.getSubDirectories(dir, true));
            } else {
                matchingParentDirs.add(dir);
            }
        }
        if (matchingParentDirs.size() > 0) {
            while (tokenizer.hasMoreTokens()) {
                String newToken = tokenizer.nextToken();
                Vector<File> tempMatchingParentDirs = new Vector<File>();
                Enumeration enm = matchingParentDirs.elements();
                while (enm.hasMoreElements()) {
                    File dir2 = (File)enm.nextElement();
                    String path = dir2.getAbsolutePath().replace('\\', '/');
                    path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
                    File newDir = new File(path + newToken);
                    if (!newDir.exists()) continue;
                    if (newToken.endsWith("/")) {
                        tempMatchingParentDirs.addAll(DirUtil.getSubDirectories(newDir, true));
                        continue;
                    }
                    tempMatchingParentDirs.add(newDir);
                }
                matchingParentDirs.clear();
                matchingParentDirs.addAll(tempMatchingParentDirs);
            }
        }
        return matchingParentDirs;
    }

    public static Vector getDirTokens(File dir) {
        Assertion.notNull(dir, "this arg is required; it must not be null");
        return DirUtil.getDirTokens(dir.getAbsolutePath());
    }

    public static File getDestinationDirectory(File sourceDir, String sourcePattern, String destPattern) {
        Assertion.notNull(sourceDir, "this arg is required; it must not be null");
        if (DirUtil.getDirTokens(sourcePattern, "*").size() != DirUtil.getDirTokens(destPattern, "*").size()) {
            throw new RuntimeException("Source pattern and destination pattern do not have equal number of *: " + sourcePattern + "    " + destPattern);
        }
        Vector sourcePatternTokens = DirUtil.getDirTokens(sourcePattern);
        Vector sourceTokens = DirUtil.getDirTokens(sourceDir);
        StringBuffer destBuf = new StringBuffer(destPattern);
        for (int i = 0; i < sourcePatternTokens.size(); ++i) {
            if (!((String)sourcePatternTokens.elementAt(i)).equals("*")) continue;
            String correspondingSourceDir = (String)sourceTokens.elementAt(i);
            destBuf = destBuf.replace(destBuf.indexOf("*"), destBuf.indexOf("*") + 1, correspondingSourceDir);
        }
        return new File(destBuf.toString());
    }

    public static Vector getDirTokens(String dirPath, String delim) {
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        StringTokenizer stringTokenizer = new StringTokenizer(dirPath, delim);
        Vector<String> dirTokens = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            dirTokens.addElement(stringTokenizer.nextToken());
        }
        return dirTokens;
    }

    public static Vector getDirTokens(String dirPath) {
        Assertion.notNull(dirPath, "this arg is required; it must not be null");
        return DirUtil.getDirTokens(dirPath, "\\/");
    }

    public static boolean isDirPatternMatch(Vector baseDirTokens, Vector dirTokens) {
        Assertion.notNull(baseDirTokens, "this arg is required; it must not be null");
        boolean matchesOK = true;
        Enumeration baseEnum = baseDirTokens.elements();
        Enumeration enm = dirTokens.elements();
        while (baseEnum.hasMoreElements()) {
            String baseToken = (String)baseEnum.nextElement();
            String token = (String)enm.nextElement();
            if (baseToken.equals("*") || baseToken.equalsIgnoreCase(token)) continue;
            matchesOK = false;
            break;
        }
        return matchesOK;
    }

    public static boolean removeDir(File dir) {
        if (dir != null && dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                boolean isFileDeletedSuccessfully;
                boolean isSubDirDeletedSuccessfully;
                if (!(files[i].isDirectory() ? !(isSubDirDeletedSuccessfully = DirUtil.removeDir(files[i])) : !(isFileDeletedSuccessfully = files[i].delete()))) continue;
                return false;
            }
            return dir.delete();
        }
        return true;
    }
}

