/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.location;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.location.DirUtil;

public abstract class PathUtil {
    private static final String META_INF = "META-INF";
    private static final String MAVAN_RESOURCES = "src/main/resources";
    private static final String JAVA_RESOURCES = "src/";
    public static ClassLoader overridenClassLoader;

    public static String getResourcesContextPath() {
        URI path = PathUtil.getResoucesURI(MAVAN_RESOURCES);
        if (path != null) {
            return path.getPath();
        }
        path = PathUtil.getResoucesURI(JAVA_RESOURCES);
        if (path != null) {
            return path.getPath();
        }
        return new File("").getAbsolutePath();
    }

    public static String getContextPath() {
        return new File("").getAbsolutePath();
    }

    public static ClassLoader getContextClassLoader() {
        return overridenClassLoader != null ? overridenClassLoader : Thread.currentThread().getContextClassLoader();
    }

    public static URL[] getClassPath() {
        ClassLoader cl = PathUtil.getContextClassLoader();
        URL[] urls = ((URLClassLoader)cl).getURLs();
        return urls;
    }

    public static List<URL> getResoucePath() throws URISyntaxException {
        ClassLoader cl = PathUtil.getContextClassLoader();
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> enumeration = cl.getResources(META_INF);
            while (enumeration.hasMoreElements()) {
                File file = new File(enumeration.nextElement().getPath());
                if (!file.isDirectory()) continue;
                for (File _file : DirUtil.getDirFiles(file.getAbsolutePath())) {
                    list.add(_file.toURL());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<String> getClassPathURL() {
        ArrayList<String> LIST = new ArrayList<String>();
        for (URL url : PathUtil.getClassPath()) {
            LIST.add(url.getPath());
        }
        return LIST;
    }

    public static URL findAsResource(String _path) {
        Assertion.notNull(_path, "this arg is required; it must not be null");
        URL url = null;
        ClassLoader contextClassLoader = PathUtil.getContextClassLoader();
        if (contextClassLoader != null) {
            url = contextClassLoader.getResource(_path);
        }
        if ((url = PathUtil.class.getClassLoader().getResource(_path)) != null) {
            return url;
        }
        url = ClassLoader.getSystemClassLoader().getResource(_path);
        if (url == null) {
            try {
                return new File(_path).toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public static URL locateURLConfig(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return PathUtil.findAsResource(path);
        }
    }

    public static boolean isValidPath(String _path) {
        block4: {
            Assertion.notNull(_path, "this arg is required; it must not be null");
            try {
                URL url = new URL(_path);
                if (url == null) break block4;
                try {
                    url.toURI();
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return true;
    }

    public static URI locateURIConfig(String path) {
        Assertion.notNull(path, "this arg is required; it must not be null");
        try {
            try {
                return new URL(path).toURI();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            try {
                return PathUtil.findAsResource(path).toURI();
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    public static String getResoucesPath(String path) {
        Assertion.notNull(path, "this arg is required; it must not be null");
        URL url = ClassLoader.getSystemClassLoader().getResource(path);
        if (url == null) {
            return null;
        }
        return url.getPath();
    }

    public static URL getResoucesURL(String _path) {
        Assertion.notNull(_path, "this arg is required; it must not be null");
        URL url = ClassLoader.getSystemClassLoader().getResource(_path);
        return url;
    }

    public static URI getResoucesURI(String _path) {
        Assertion.notNull(_path, "this arg is required; it must not be null");
        URL url = ClassLoader.getSystemClassLoader().getResource(_path);
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (Exception e) {
            try {
                return PathUtil.findAsResource(_path).toURI();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return uri;
    }

    public static String getContextNameFromURLString(String _path) {
        Assertion.notNull(_path, "this arg is required; it must not be null");
        StringTokenizer tokenizer = new StringTokenizer(_path, "/");
        String lastToken = null;
        while (tokenizer.hasMoreTokens()) {
            lastToken = tokenizer.nextToken();
        }
        return lastToken;
    }

    public static File resources(String suffix) {
        for (File file : DirUtil.filesWithSubDir(System.getProperty("user.dir"))) {
            if (!file.getAbsolutePath().endsWith(suffix)) continue;
            return file;
        }
        return null;
    }
}

