/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.location;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.location.PathUtil;
import org.brijframework.util.resouces.FilterUtil;

public class StreamUtil {
    public static final int BUFFER_SIZE = 4096;

    public static String getResource(String resourse) {
        String resurces = "";
        InputStream inStream = StreamUtil.getResourceAsStream(resourse);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                resurces = resurces + line + "\n";
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return resurces;
    }

    public static File[] getAllResurces(String path, String extension) {
        URL url = PathUtil.findAsResource(path);
        File uri = null;
        try {
            uri = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
        return FilterUtil.dirFilesWithSubDir(uri.getPath(), extension);
    }

    public static InputStream getConfigStream(String path) {
        URL url = PathUtil.locateURLConfig(path);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = PathUtil.getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = StreamUtil.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = StreamUtil.class.getClassLoader().getResourceAsStream(stripped);
        }
        return stream;
    }

    public static InputStream getUserResourceAsStream(String resource) {
        boolean hasLeadingSlash = resource.startsWith("/");
        String stripped = hasLeadingSlash ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = PathUtil.getContextClassLoader();
        if (classLoader != null && (stream = classLoader.getResourceAsStream(resource)) == null && hasLeadingSlash) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = StreamUtil.class.getClassLoader().getResourceAsStream(resource);
        }
        if (stream == null && hasLeadingSlash) {
            stream = StreamUtil.class.getClassLoader().getResourceAsStream(stripped);
        }
        return stream;
    }

    public static String loadFromStream(InputStream io) {
        try {
            int i;
            StringBuffer buffer = new StringBuffer();
            while ((i = io.read()) != -1) {
                buffer.append((char)i);
            }
            io.close();
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] loadInBufferModeFromStream(InputStream inputStream) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(inputStream);
        int pos = 0;
        int i = 0;
        byte[] data = new byte[bin.available()];
        while ((i = bin.read()) != -1) {
            data[pos++] = (byte)i;
        }
        bin.close();
        return data;
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        StreamUtil.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static String copyToString(InputStream in, Charset charset) throws IOException {
        Assertion.notNull(in, "No InputStream specified");
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buffer = new char[4096];
        int bytesRead = -1;
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Assertion.notNull(in, "No input byte array specified");
        Assertion.notNull(out, "No OutputStream specified");
        out.write(in);
    }

    public static void copy(String in, Charset charset, OutputStream out) throws IOException {
        Assertion.notNull(in, "No input String specified");
        Assertion.notNull(charset, "No charset specified");
        Assertion.notNull(out, "No OutputStream specified");
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        writer.write(in);
        ((Writer)writer).flush();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        Assertion.notNull(in, "No InputStream specified");
        Assertion.notNull(out, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    public static InputStream nonClosing(InputStream in) {
        Assertion.notNull(in, "No InputStream specified");
        return new NonClosingInputStream(in);
    }

    public static OutputStream nonClosing(OutputStream out) {
        Assertion.notNull(out, "No OutputStream specified");
        return new NonClosingOutputStream(out);
    }

    public static boolean writeJsonToFile(Path path, Object data) {
        boolean bl;
        StringWriter out = new StringWriter();
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            String json = writer.writeValueAsString(data);
            byte[] bytes = json.getBytes();
            Files.write(path, bytes, StandardOpenOption.WRITE);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        out.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readJsonFromFile(Path path, TypeReference<T> valueType) {
        try (StringWriter out = new StringWriter();){
            ObjectMapper mapper = new ObjectMapper();
            Object object = mapper.readValue(path.toFile(), valueType);
            return (T)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        public NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int let) throws IOException {
            this.out.write(b, off, let);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

