/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.resouces;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CSVUtil {
    public static String listToCSV(List<Map<String, Object>> dataArray) {
        String data = "";
        if (dataArray.size() > 0) {
            int hi = 0;
            LinkedHashMap<String, Object> headerMap = CSVUtil.headerMap(dataArray);
            for (String string : headerMap.keySet()) {
                data = data + CSVUtil.replaceComma(string);
                data = hi < headerMap.keySet().size() - 1 ? data + "," : data + "\n";
                ++hi;
            }
            for (Map map : dataArray) {
                int index = 0;
                for (String key : headerMap.keySet()) {
                    data = map.get(key) != null ? data + CSVUtil.replaceComma(map.get(key).toString()) : data + " ";
                    data = index < headerMap.keySet().size() - 1 ? data + "," : data + "\n";
                    ++index;
                }
            }
        }
        return data;
    }

    private static String replaceComma(String description) {
        if (description != null) {
            return description.replaceAll("\\,", "^").replaceAll("\"", "'");
        }
        return " ";
    }

    private static LinkedHashMap<String, Object> headerMap(List<Map<String, Object>> dataArray) {
        int max = 0;
        int index = 0;
        int i = 0;
        for (Map<String, Object> map : dataArray) {
            if (max < map.keySet().size()) {
                index = i;
                max = map.keySet().size();
            }
            ++i;
        }
        return new LinkedHashMap<String, Object>(dataArray.get(index));
    }

    public static void main(String[] args) {
        ArrayList<Map<String, Object>> dataArray = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("id", "1");
        map.put("name", "ram kishor");
        map.put("email", "ram@mail.com");
        map.put("addres", "noida");
        for (int i = 0; i <= 10; ++i) {
            dataArray.add(map);
        }
        System.out.println(CSVUtil.listToCSV(dataArray));
    }
}

