/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.resouces;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

public class FilterUtil {
    public static List<File> folderList = new ArrayList<File>();
    public static List<File> filelist = new ArrayList<File>();

    public static File[] getFilesListByExtension(String dirPath, final String extension) {
        FilenameFilter extensionFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(extension);
            }
        };
        File dir = new File(dirPath);
        File[] files = dir.listFiles(extensionFilter);
        return files;
    }

    public static File[] getFileListBySize(String dirPath, final int size) {
        FileFilter sizeFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.length() > (long)(size * 1024 * 1024);
            }
        };
        File dir = new File(dirPath);
        File[] files = dir.listFiles(sizeFilter);
        return files;
    }

    public static File[] dirFilesWithSubDir(String dir, final String extension) {
        File[] fList;
        File directory = new File(dir);
        FilenameFilter extensionFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(extension) || file.isDirectory();
            }
        };
        for (File file : fList = directory.listFiles(extensionFilter)) {
            if (file.isDirectory()) {
                FilterUtil.dirFilesWithSubDir(file.getAbsolutePath(), extension);
                continue;
            }
            filelist.add(file);
        }
        File[] files = new File[filelist.size()];
        int i = 0;
        for (File file : filelist) {
            files[i++] = file;
        }
        return files;
    }

    public static File[] dirFilesWithSubDir(String dir, final int size) {
        File[] fList;
        File directory = new File(dir);
        FileFilter sizeFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.length() > (long)(size * 1024 * 1024);
            }
        };
        for (File file : fList = directory.listFiles(sizeFilter)) {
            if (file.isFile()) {
                filelist.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            FilterUtil.dirFilesWithSubDir(file.getAbsolutePath(), size);
        }
        File[] files = new File[filelist.size()];
        int i = 0;
        for (File file : filelist) {
            files[i++] = file;
        }
        return files;
    }
}

