/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.casting;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.brijframework.util.casting.DateUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.reflect.LogicUnit;
import org.brijframework.util.text.StringUtil;
import org.brijframework.util.validator.ValidationUtil;

public abstract class CastingUtil {
    public static final String[] specialNames = new String[]{"", " thousand", " lakh", " carore", " carore", " arave", " arave", " karav"};
    public static final String[] tensNames = new String[]{"", " ten", " twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety"};
    public static final String[] numNames = new String[]{"", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};
    public static final Class<?> _ObjectClass = Object.class;
    public static final Class<?> _ClassClass = Class.class;
    public static final Class<?> _StringClass = String.class;
    public static final Class<?> _NumberClass = Number.class;
    public static final Class<?> _BigDecimalClass = BigDecimal.class;
    public static final Class<?> _BigIntegerClass = BigInteger.class;
    public static final Class<?> _BooleanClass = Boolean.class;
    public static final Class<?> _DateClass = java.util.Date.class;
    public static final Class<?> _LocaleClass = Locale.class;
    public static final Class<?> _ShortClass = Short.class;
    public static final Class<?> _ByteClass = Byte.class;
    public static final Class<?> _IntegerClass = Integer.class;
    public static final Class<?> _LongClass = Long.class;
    public static final Class<?> _DoubleClass = Double.class;
    public static final Class<?> _FloatClass = Float.class;
    public static final Class<?> _VoidClass = Void.class;
    public static final Class<?> _CharacterClass = Character.class;
    public static final Short _shortOff = new Short(0);
    public static final Short _shortOn = new Short(1);
    public static final Short _zeroShort = Short.valueOf("0");
    public static final Integer _zeroInteger = 0;
    public static final Double _zeroDobule = 0.0;
    public static final BigDecimal _zeroBigDecimal = BigDecimal.valueOf(0L);
    public static final BigInteger _zeroBigInteger = BigInteger.valueOf(0L);
    private static final Integer[] _integers = new Integer[517];
    private static final String undefined = "undefined";

    public static Class<?> getTargetClass(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (!type.getName().equals(Type.class.getName()) && InstanceUtil.isAssignable(type)) {
            return type;
        }
        if (Map.class.isAssignableFrom(type)) {
            return HashMap.class;
        }
        if (List.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return HashSet.class;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        return type;
    }

    public static Class<?> getTargetClass(Method field, Class<?> type) {
        Class<?> typeOf = CastingUtil.getTargetClass(type);
        if (typeOf == null) {
            return null;
        }
        if (typeOf.getName().equals(Type.class.getName())) {
            return field.getReturnType();
        }
        return type;
    }

    public static Class<?> getTargetClass(Field field, Class<?> type) {
        Class<?> typeOf = CastingUtil.getTargetClass(type);
        if (typeOf == null) {
            return null;
        }
        if (typeOf.getName().equals(Type.class.getName())) {
            return field.getType();
        }
        return typeOf;
    }

    public static Object defaultValue(Field field) {
        if (field == null) {
            return null;
        }
        if (String.class.isAssignableFrom(field.getType())) {
            return CastingUtil.stringValue(null);
        }
        if (Float.class.isAssignableFrom(field.getType())) {
            return Float.valueOf(CastingUtil.floatValue(null));
        }
        if (Double.class.isAssignableFrom(field.getType())) {
            return CastingUtil.doubleValue(null);
        }
        if (Integer.class.isAssignableFrom(field.getType())) {
            return CastingUtil.intValue(null);
        }
        if (Short.class.isAssignableFrom(field.getType())) {
            return CastingUtil.shortValue(null);
        }
        if (Boolean.class.isAssignableFrom(field.getType())) {
            return false;
        }
        if (Character.class.isAssignableFrom(field.getType())) {
            return new Character('\u0000');
        }
        if (Long.class.isAssignableFrom(field.getType())) {
            return CastingUtil.longValue(null);
        }
        return null;
    }

    public static short shortValue(Object v) {
        if (v == null) {
            return 0;
        }
        if (v instanceof Number) {
            return ((Number)v).shortValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.trim().length() == 0 || s.equals("null")) {
                return 0;
            }
            try {
                if (s.indexOf(46) >= 0) {
                    return new BigDecimal(s).shortValue();
                }
                return Short.parseShort(s);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return CastingUtil.shortValue(v.toString());
    }

    public static int intValue(Object v) {
        if (v == null) {
            return 0;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.trim().length() == 0 || s.equals("null")) {
                return 0;
            }
            try {
                if (s.indexOf(46) >= 0) {
                    return new BigDecimal(s).intValue();
                }
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return CastingUtil.intValue(v.toString());
    }

    public static long longValue(Object v) {
        if (v == null) {
            return 0L;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0 || s.equals("null")) {
                return 0L;
            }
            try {
                if (s.indexOf(46) >= 0) {
                    return new BigDecimal(s).longValue();
                }
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return CastingUtil.longValue(v.toString());
    }

    public static float floatValue(Object v) {
        if (v == null) {
            return 0.0f;
        }
        if (v instanceof Number) {
            return ((Number)v).floatValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0 || s.equals("null")) {
                return 0.0f;
            }
            try {
                if (s.indexOf(46) >= 0) {
                    return new BigDecimal(s).floatValue();
                }
                return Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return CastingUtil.floatValue(v.toString());
    }

    public static double doubleValue(Object v) {
        if (v == null) {
            return 0.0;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.equalsIgnoreCase("y") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("true")) {
                return 1.0;
            }
            if (s.trim().length() == 0 || s.equals("null")) {
                return 0.0;
            }
            try {
                if (s.indexOf(46) >= 0) {
                    return new BigDecimal(s).doubleValue();
                }
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return CastingUtil.doubleValue(v.toString());
    }

    public static boolean boolValue(String s) {
        if (s == null) {
            return false;
        }
        if (s.equals("") || s.equals("null")) {
            return false;
        }
        if (s.equalsIgnoreCase("n") || s.equalsIgnoreCase("no")) {
            return false;
        }
        if (s.equalsIgnoreCase("f") || s.equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equalsIgnoreCase("u") || s.equalsIgnoreCase(undefined)) {
            return false;
        }
        if (s.equalsIgnoreCase("0") || s.equalsIgnoreCase("zero") || s.equalsIgnoreCase("off")) {
            return false;
        }
        if (s.equalsIgnoreCase("y") || s.equalsIgnoreCase("YES")) {
            return true;
        }
        if (s.equalsIgnoreCase("t") || s.equalsIgnoreCase("true")) {
            return true;
        }
        return s.equalsIgnoreCase("1") || s.equalsIgnoreCase("one") || s.equalsIgnoreCase("on");
    }

    public static boolean boolValue(Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof String) {
            return CastingUtil.boolValue((String)v);
        }
        if (v instanceof Character) {
            char c0 = ((Character)v).charValue();
            if (c0 == 'N' || c0 == 'n') {
                return false;
            }
            if (c0 == 'f' || c0 == 'F') {
                return false;
            }
            if (c0 == 'u' || c0 == 'U') {
                return false;
            }
            if (c0 == 'y' || c0 == 'Y') {
                return true;
            }
            if (c0 == 't' || c0 == 'T') {
                return true;
            }
        } else {
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            if (v instanceof Number) {
                return ((Number)v).intValue() != 0;
            }
            if (v instanceof Collection) {
                return ((Collection)v).size() > 0;
            }
        }
        return false;
    }

    private static Character charValue(Object v) {
        if (v == null) {
            return Character.valueOf(' ');
        }
        if (v instanceof Character) {
            return Character.valueOf(((Character)v).charValue());
        }
        if (v instanceof Number) {
            return Character.valueOf((char)((Number)v).intValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.trim().length() == 0 || s.equals("null")) {
                return Character.valueOf(' ');
            }
            if (s.trim().length() == 1) {
                return Character.valueOf(s.charAt(0));
            }
        }
        return null;
    }

    public static String stringValue(Object _value) {
        if (_value == null) {
            return null;
        }
        if (_value instanceof String) {
            return String.valueOf(_value);
        }
        if (_value instanceof Object[]) {
            return CastingUtil.stringValueForArray((Object[])_value);
        }
        return _value.toString();
    }

    public static String stringValueForArray(Object[] _array) {
        if (_array == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(_array.length * 16);
        sb.append("[ ");
        boolean isFirst = true;
        for (Object o : _array) {
            String s = CastingUtil.stringValue(o);
            if (s == null) {
                s = " ";
            }
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(s);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static java.util.Date dateValue(Object _v, int _style, Locale _locale) {
        if (_v == null) {
            return null;
        }
        if (_v instanceof java.util.Date) {
            return (java.util.Date)_v;
        }
        if (_v instanceof Calendar) {
            return ((Calendar)_v).getTime();
        }
        if (_v instanceof String) {
            String s = ((String)_v).trim();
            if (s.length() == 0) {
                return null;
            }
            if (undefined.equals(s)) {
                return null;
            }
            if (ValidationUtil.isValidLong(s)) {
                return new java.util.Date(Long.parseLong(s));
            }
            DateFormat df = DateFormat.getDateInstance(_style, _locale);
            try {
                return df.parse(s.replaceAll("_", "/"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_v instanceof Number) {
            return new java.util.Date(((Number)_v).longValue());
        }
        try {
            Method m = _v.getClass().getMethod("dateValue", new Class[0]);
            if (m != null) {
                Object v = m.invoke(_v, new Object[0]);
                if (v == null) {
                    return null;
                }
                if (v != _v) {
                    return CastingUtil.dateValue(v, _style, _locale);
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println("WARN: unexpected object in Object.dateValue(): " + _v);
        return null;
    }

    public static java.util.Date dateValue(Object _v) {
        return CastingUtil.dateValue(_v, 3, Locale.getDefault());
    }

    public static Timestamp timeStampValue(Object _v, int _style, Locale _locale) {
        if (_v == null) {
            return null;
        }
        if (_v instanceof Timestamp) {
            return (Timestamp)_v;
        }
        if (_v instanceof Calendar) {
            return new Timestamp(((Calendar)_v).getTimeInMillis());
        }
        if (_v instanceof String) {
            String s = ((String)_v).trim();
            if (s.length() == 0) {
                return null;
            }
            if (undefined.equals(s)) {
                return null;
            }
            if (ValidationUtil.isValidLong(s)) {
                return new Timestamp(Long.parseLong(s));
            }
            DateFormat df = DateFormat.getDateTimeInstance(_style, 0, _locale);
            try {
                return new Timestamp(df.getCalendar().getTimeInMillis());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_v instanceof Number) {
            return new Timestamp(((Number)_v).longValue());
        }
        try {
            Method m = _v.getClass().getMethod("timeStampValue", new Class[0]);
            if (m != null) {
                Object v = m.invoke(_v, new Object[0]);
                if (v == null) {
                    return null;
                }
                if (v != _v) {
                    return CastingUtil.timeStampValue(v, _style, _locale);
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println("WARN: unexpected object in Object.dateValue(): " + _v);
        return null;
    }

    public static java.util.Date timeStampValue(Object _v) {
        return CastingUtil.timeStampValue(_v, 3, Locale.getDefault());
    }

    public static Object castObject(Object _value, Type type) {
        return CastingUtil.castObject(_value, (Class)type);
    }

    public static int valueInt(Object _value) {
        return (Integer)CastingUtil.castObject(_value, Integer.TYPE);
    }

    public static float valueFloat(Object _value) {
        return ((Float)CastingUtil.castObject(_value, Float.TYPE)).floatValue();
    }

    public static Object castObject(Object _value, Class<?> type) {
        if (Boolean.class.isAssignableFrom(type) || type.toString().equals("boolean")) {
            return CastingUtil.boolValue(_value);
        }
        if (Short.class.isAssignableFrom(type) || type.toString().equals("boolean")) {
            return CastingUtil.shortValue(_value);
        }
        if (Integer.class.isAssignableFrom(type) || type.toString().equals("int")) {
            return CastingUtil.intValue(_value);
        }
        if (Long.class.isAssignableFrom(type) || type.toString().equals("long")) {
            return CastingUtil.longValue(_value);
        }
        if (Float.class.isAssignableFrom(type) || type.toString().equals("float")) {
            return Float.valueOf(CastingUtil.floatValue(_value));
        }
        if (Double.class.isAssignableFrom(type) || type.toString().equals("double")) {
            return CastingUtil.doubleValue(_value);
        }
        if (Character.class.isAssignableFrom(type) || type.toString().equals("char")) {
            return CastingUtil.charValue(_value);
        }
        if (_value == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(type)) {
            ?[] objects;
            for (Object object : objects = type.getEnumConstants()) {
                if (!object.toString().equals(_value.toString())) continue;
                return object;
            }
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return CastingUtil.stringValue(_value);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return CastingUtil.dateValue(_value);
        }
        if (Date.class.isAssignableFrom(type)) {
            return DateUtil.sqlDateObject(_value);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return DateUtil.sqlTimestempObject(_value);
        }
        if (Map.class.isAssignableFrom(_value.getClass())) {
            Map inObject = (Map)InstanceUtil.getInstance(CastingUtil.getTargetClass(type), new Object[0]);
            Map _map = (Map)_value;
            for (String key : _map.keySet()) {
                inObject.put(key, _map.get(key));
            }
            return inObject;
        }
        if (Class.class.isAssignableFrom(type) && String.class.isAssignableFrom(_value.getClass())) {
            return _value.toString();
        }
        if (_value != null && !type.isAssignableFrom(_value.getClass())) {
            return null;
        }
        if (type.isAssignableFrom(_value.getClass())) {
            return _value;
        }
        return _value;
    }

    public static <T> T castObject(Object _value, Class<?> type, Class<?> paramType) {
        if (Collection.class.isAssignableFrom(type)) {
            Collection inObject = (Collection)InstanceUtil.getInstance(type, new Object[0]);
            if (paramType != null) {
                if (ValidationUtil.isPrimative(paramType).booleanValue()) {
                    inObject.addAll((Collection)_value);
                } else {
                    for (Object _obj : (Collection)_value) {
                        Object _bean = InstanceUtil.getInstance(paramType, new Object[0]);
                        if (_obj instanceof Map) {
                            LogicUnit.setAllField(_bean, (Map)_obj);
                        }
                        inObject.add(_bean);
                    }
                }
            } else {
                inObject.addAll((Collection)_value);
            }
            return (T)inObject;
        }
        return (T)CastingUtil.castObject(_value, type);
    }

    public static String toDecimal(String value, int base) {
        int pow = 0;
        long result = 0L;
        for (char c : StringUtil.reverseText(value).toCharArray()) {
            result += (long)((int)(Math.pow(base, pow++) * (double)Character.getNumericValue(c)));
        }
        return String.valueOf(result);
    }

    public static String decimalToAnyNumber(String value, int base) {
        long data;
        StringBuffer strBuffer = new StringBuffer();
        if (base == 16) {
            String[] hex = new String[]{"A", "B", "C", "D", "E", "F"};
            for (data = Long.valueOf(value).longValue(); data > 0L; data /= (long)base) {
                int r = (int)data % base;
                strBuffer.append(r < 10 ? Integer.valueOf(r) : hex[r - 10]);
            }
            return StringUtil.reverseText(strBuffer.toString());
        }
        while (data > 0L) {
            strBuffer.append(data % (long)base);
            data /= (long)base;
        }
        return StringUtil.reverseText(strBuffer.toString());
    }

    public static String binaryToOctal(String binary) {
        return CastingUtil.decimalToAnyNumber(CastingUtil.toDecimal(binary, 2), 8);
    }

    public static String binaryToHexa(String binary) {
        return CastingUtil.decimalToAnyNumber(CastingUtil.toDecimal(binary, 2), 16);
    }

    public static String octalToBinary(String octal) {
        return CastingUtil.decimalToAnyNumber(CastingUtil.toDecimal(octal, 8), 2);
    }

    public static String octalToHexa(String octal) {
        return CastingUtil.decimalToAnyNumber(CastingUtil.toDecimal(octal, 8), 16);
    }

    public static String hexaToBinary(String hexa) {
        return CastingUtil.decimalToAnyNumber(CastingUtil.toDecimal(hexa, 16), 2);
    }

    public static String hexaToOctal(String hexa) {
        return CastingUtil.decimalToAnyNumber(CastingUtil.toDecimal(hexa, 16), 8);
    }

    public static Double getDoubleFromString(String val1) {
        if ((val1 = val1.trim()).startsWith("(") && val1.endsWith(")")) {
            return new Double(new Double(val1.substring(1, val1.length() - 1)) * -1.0);
        }
        return new Double(val1);
    }

    public static int getIntforBoolean(boolean value) {
        if (!value) {
            return 0;
        }
        return 1;
    }

    public static boolean getBooleanValue(Integer i) {
        return i == 1;
    }

    public static Double getDoubleFromDict(Hashtable<?, ?> hash, String key) {
        Object o = hash.get(key);
        if (o instanceof String) {
            return new Double(Double.parseDouble((String)o));
        }
        Number numb = (Number)o;
        if (numb == null) {
            return new Double(0.0);
        }
        return new Double(numb.doubleValue());
    }

    public static String toRadix(String integer, int inRadix, int outRadix) {
        if (outRadix == inRadix) {
            return integer;
        }
        if (outRadix == 10) {
            return CastingUtil.toDecimal(integer, inRadix);
        }
        if (inRadix == 10) {
            return CastingUtil.decimalToAnyNumber(integer, outRadix);
        }
        return CastingUtil.decimalToAnyNumber(CastingUtil.toDecimal(integer, inRadix), outRadix);
    }

    public static String byteArrayToHex(byte[] a) {
        String hexDigitChars = "0123456789abcdef";
        StringBuffer buf = new StringBuffer(a.length * 2);
        for (int cx = 0; cx < a.length; ++cx) {
            int hn = (a[cx] & 0xFF) / 16;
            int ln = a[cx] & 0xF;
            buf.append(hexDigitChars.charAt(hn));
            buf.append(hexDigitChars.charAt(ln));
        }
        return buf.toString();
    }

    public static String dayInWord(int day) {
        String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thesday", "Friday", "Saturday"};
        return 0 <= day && day < 7 ? days[day] : "Not Valid Day Number";
    }

    private static String convertLessThanOneThousand(int number) {
        String current;
        if (number % 100 < 20) {
            current = numNames[number % 100];
            number /= 100;
        } else {
            current = numNames[number % 10];
            current = tensNames[(number /= 10) % 10] + current;
            number /= 10;
        }
        if (number == 0) {
            return current;
        }
        return numNames[number] + " hundred" + current;
    }

    public static String numberInWord(long number) {
        if (number == 0L) {
            return "zero";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "negative";
        }
        String current = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = CastingUtil.convertLessThanOneThousand((int)n);
                current = s + specialNames[place] + current;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + current).trim();
    }

    public static Integer integerForInt(int i) {
        if (i < 513 && i >= -3) {
            return _integers[i + 3];
        }
        return i;
    }

    public static Object dobuleTOshort(Double d) {
        return (short)(d * 2.0);
    }

    public static Object convertNumberOrBooleanIntoCompatibleValue(Object obj, Class<?> class1) {
        if (obj != null) {
            Class<?> class2 = obj.getClass();
            if (ValidationUtil.isClassAsBoolean(class1)) {
                return class2 != _BooleanClass ? CastingUtil.convertNumberIntoBooleanValue((Number)obj) : obj;
            }
            return class2 != _BooleanClass ? (Number)CastingUtil.convertNumberIntoCompatibleValue((Number)obj, class1) : (Number)CastingUtil.convertBooleanIntoCompatibleNumberValue((Boolean)obj, class1);
        }
        return obj;
    }

    public static Number convertBooleanIntoCompatibleNumberValue(Boolean boolean1, Class<?> class1) {
        return CastingUtil.convertNumberIntoCompatibleValue(CastingUtil.convertBooleanIntoNumberValue(boolean1), class1);
    }

    public static Number convertNumberIntoCompatibleValue(Number number, Class<?> class1) {
        Class<?> class2;
        if (number != null && (class2 = number.getClass()) != class1) {
            if (class1 == Integer.TYPE || class1 == _IntegerClass) {
                return CastingUtil.integerForInt(number.intValue());
            }
            if (class1 == Double.TYPE || class1 == _DoubleClass) {
                return new Double(number.doubleValue());
            }
            if (class1 == Float.TYPE || class1 == _FloatClass) {
                return new Float(number.floatValue());
            }
            if (class1 == Long.TYPE || class1 == _LongClass) {
                return new Long(number.longValue());
            }
            if (class1 == Short.TYPE || class1 == _ShortClass) {
                return new Short(number.shortValue());
            }
            if (class1 == Byte.TYPE || class1 == _ByteClass) {
                return new Byte(number.byteValue());
            }
            if (class1 == _BigDecimalClass) {
                if (class2 == _IntegerClass || class2 == _LongClass || class2 == _ShortClass || class2 == _ByteClass) {
                    return BigDecimal.valueOf(number.longValue());
                }
                if (number instanceof BigInteger) {
                    return new BigDecimal((BigInteger)number);
                }
                return new BigDecimal(number.doubleValue());
            }
            if (class1 == _BigIntegerClass) {
                if (number instanceof BigDecimal) {
                    return ((BigDecimal)number).toBigInteger();
                }
                return BigInteger.valueOf(number.longValue());
            }
        }
        return number;
    }

    public static int compareNumbersOrBooleans(Object obj, Object obj1) {
        if (obj == obj1) {
            return 0;
        }
        if (obj == null) {
            return -1;
        }
        if (obj1 == null) {
            return 1;
        }
        Class<?> class1 = obj.getClass();
        Class<?> class2 = obj1.getClass();
        if (class1 == _BooleanClass && class2 == _BooleanClass) {
            boolean flag1;
            boolean flag = (Boolean)obj;
            if (flag == (flag1 = ((Boolean)obj1).booleanValue())) {
                return 0;
            }
            return !flag1 ? 1 : -1;
        }
        if (class1 == _BooleanClass) {
            return CastingUtil.compareNumbers(CastingUtil.convertBooleanIntoNumberValue((Boolean)obj), (Number)obj1);
        }
        if (class2 == _BooleanClass) {
            return CastingUtil.compareNumbers((Number)obj, CastingUtil.convertBooleanIntoNumberValue((Boolean)obj1));
        }
        return CastingUtil.compareNumbers((Number)obj, (Number)obj1);
    }

    public static Number convertBooleanIntoNumberValue(Boolean boolean1) {
        if (boolean1 != null) {
            return boolean1 != false ? _shortOn : _shortOff;
        }
        return null;
    }

    public static Boolean convertNumberIntoBooleanValue(Number number) {
        if (number != null) {
            Class<?> class1 = number.getClass();
            if (class1 == _IntegerClass || class1 == _ShortClass || class1 == _ByteClass) {
                return number.intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (class1 == _LongClass) {
                return number.longValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            if (class1 == _DoubleClass || class1 == _FloatClass) {
                return number.doubleValue() == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (class1 == _BigDecimalClass) {
                return ((BigDecimal)number).compareTo(_zeroBigDecimal) == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (class1 == _BigIntegerClass) {
                return ((BigInteger)number).compareTo(_zeroBigInteger) == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            return number.doubleValue() == 0.0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int compareNumbers(Number number, Number number1) {
        double d1;
        Class<?> class3;
        Class<?> class2;
        if (number == number1) {
            return 0;
        }
        if (number == null) {
            return -1;
        }
        if (number1 == null) {
            return 1;
        }
        Class<?> class1 = number.getClass();
        if (class1 != (class2 = number1.getClass())) {
            boolean flag3;
            boolean flag = class1 == _ShortClass || class1 == _ByteClass;
            boolean flag1 = class2 == _ShortClass || class2 == _ByteClass;
            boolean flag2 = flag || class1 == _IntegerClass || class1 == _LongClass;
            boolean bl = flag3 = flag1 || class2 == _IntegerClass || class2 == _LongClass;
            if (flag2 && flag3) {
                long l3;
                long l2 = number.longValue();
                if (l2 == (l3 = number1.longValue())) {
                    return 0;
                }
                return l2 >= l3 ? 1 : -1;
            }
            if ((flag || class1 == _FloatClass || class1 == _DoubleClass) && (flag1 || class2 == _FloatClass || class2 == _DoubleClass)) {
                double d3;
                double d2 = number.doubleValue();
                if (d2 == (d3 = number1.doubleValue())) {
                    return 0;
                }
                return d2 >= d3 ? 1 : -1;
            }
            if ((flag2 || class1 == _BigIntegerClass) && (flag3 || class2 == _BigIntegerClass)) {
                if (class1 != _BigIntegerClass) {
                    number = BigInteger.valueOf(number.longValue());
                }
                if (class2 != _BigIntegerClass) {
                    number1 = BigInteger.valueOf(number1.longValue());
                }
            } else {
                if (!_BigDecimalClass.isAssignableFrom(class1)) {
                    number = flag2 ? BigDecimal.valueOf(number.longValue()) : (_BigIntegerClass.isAssignableFrom(class1) ? new BigDecimal((BigInteger)number) : new BigDecimal(number.doubleValue()));
                }
                if (!_BigDecimalClass.isAssignableFrom(class2)) {
                    number1 = flag3 ? BigDecimal.valueOf(number1.longValue()) : (_BigIntegerClass.isAssignableFrom(class2) ? new BigDecimal((BigInteger)number1) : new BigDecimal(number1.doubleValue()));
                }
            }
        }
        if ((class3 = number.getClass()) == _LongClass || class3 == _IntegerClass || class3 == _ShortClass || class3 == _ByteClass) {
            long l1;
            long l = number.longValue();
            if (l == (l1 = number1.longValue())) {
                return 0;
            }
            return l >= l1 ? 1 : -1;
        }
        if (_BigDecimalClass.isAssignableFrom(class3)) {
            int i = ((BigDecimal)number).compareTo((BigDecimal)number1);
            if (i < 0) {
                return -1;
            }
            return i <= 0 ? 0 : 1;
        }
        if (_BigIntegerClass.isAssignableFrom(class3)) {
            int j = ((BigInteger)number).compareTo((BigInteger)number1);
            if (j < 0) {
                return -1;
            }
            return j <= 0 ? 0 : 1;
        }
        double d = number.doubleValue();
        if (d == (d1 = number1.doubleValue())) {
            return 0;
        }
        return d >= d1 ? 1 : -1;
    }

    public static Number intOrLongValue(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Number)v;
        }
        if (v instanceof Number) {
            long lv = ((Number)v).longValue();
            return lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE ? (long)new Integer((int)lv).intValue() : new Long(lv);
        }
        if (v instanceof String) {
            String s = ((String)v).trim();
            if (s.length() == 0) {
                return null;
            }
            long lv = CastingUtil.longValue(s);
            return lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE ? (long)new Integer((int)lv).intValue() : new Long(lv);
        }
        return CastingUtil.intOrLongValue(v.toString());
    }

    public static List<Number> listOfIntsOrLongs(Collection<?> _objs) {
        if (_objs == null) {
            return null;
        }
        ArrayList<Number> nums = new ArrayList<Number>(_objs.size());
        for (Object o : _objs) {
            Number n = CastingUtil.intOrLongValue(o);
            if (n != o && n == null) {
                return null;
            }
            nums.add(n);
        }
        return nums;
    }

    static {
        int c = 516;
        for (int i = 0; i < c; ++i) {
            CastingUtil._integers[i] = i - 3;
        }
    }
}

