/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.reflect.ParamUtil;
import org.brijframework.util.support.ReflectionAccess;

public abstract class ConstructUtil {
    public static List<Constructor<?>> getConstructors(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        ArrayList constructors = new ArrayList();
        for (Constructor<?> constructor : _class.getDeclaredConstructors()) {
            constructors.add(constructor);
        }
        constructors.sort((constructor1, constructor2) -> Integer.valueOf(constructor1.getParameterTypes().length).compareTo(constructor2.getParameterTypes().length));
        return constructors;
    }

    public static Constructor<?> getConstructor(Class<?> _class, ReflectionAccess access, Type ... types) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        for (Constructor<?> constructor : _class.getDeclaredConstructors()) {
            if (!access.isAccess(constructor.getModifiers()) || !ParamUtil.isEqualTypes(types, constructor.getParameterTypes())) continue;
            return constructor;
        }
        return null;
    }
}

