/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.reflect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.reflect.ClassUtil;
import org.brijframework.util.reflect.LogicUnit;
import org.brijframework.util.support.ReflectionAccess;
import org.brijframework.util.validator.ValidationUtil;

public abstract class FieldUtil {
    public static final String field_getName = "getName";

    private static Field findField(Field[] _fields, String _field, ReflectionAccess _accessLevel) {
        Assertion.notNull(_fields, "this arg is required; it must not be null fields");
        Assertion.notNull(_field, "this arg is required; it must not be null field");
        Assertion.notNull((Object)_accessLevel, "this arg is required; it must not be null accessLevel");
        for (Field field : _fields) {
            if (!field.getName().equals(_field) || !_accessLevel.isAccess(field.getModifiers())) continue;
            return field;
        }
        return null;
    }

    private static List<Field> fillFields(Field[] _fields, ReflectionAccess _accessLevel) {
        Assertion.notNull(_fields, "this arg is required; it must not be null fields");
        Assertion.notNull((Object)_accessLevel, "this arg is required; it must not be null accessLevel");
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : _fields) {
            if (!_accessLevel.isAccess(field.getModifiers())) continue;
            list.add(field);
        }
        return list;
    }

    public static List<Field> getAllField(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        return FieldUtil.getAllField(_class, ReflectionAccess.PUBLIC);
    }

    public static Field getField(Class<?> _class, String _field) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        Assertion.notNull(_field, "this field name is required; it must not be null");
        return FieldUtil.getField(_class, _field, ReflectionAccess.PUBLIC);
    }

    public static List<String> getFieldList(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        List<Field> collection = FieldUtil.getAllField(_class);
        return (List)LogicUnit.collectionMethod(collection, field_getName, new Object[0]);
    }

    public static List<String> getFieldList(Class<?> _class, ReflectionAccess _accessLevel) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        List<Field> collection = FieldUtil.getAllField(_class, _accessLevel);
        return (List)LogicUnit.collectionMethod(collection, field_getName, new Object[0]);
    }

    public static Field getField(Class<?> _class, String _field, ReflectionAccess _accessLevel) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        Assertion.notNull(_field, "this field name is required; it must not be null");
        Field field = FieldUtil.findField(_class.getDeclaredFields(), _field, _accessLevel);
        if (field != null) {
            return field;
        }
        if (_class.getSuperclass() != null) {
            for (Class<?> supClass : ClassUtil.getAllSuperClass(_class)) {
                field = FieldUtil.findField(supClass.getDeclaredFields(), _field, _accessLevel);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    public static Map<String, Field> getAllFieldMap(Class<?> _class, ReflectionAccess _accessLevel) {
        List<Field> fields = FieldUtil.getAllField(_class, _accessLevel);
        HashMap<String, Field> properties = new HashMap<String, Field>();
        for (Field field : fields) {
            properties.put(field.getName(), field);
        }
        return properties;
    }

    public static List<Field> getAllField(Class<?> _class, ReflectionAccess _accessLevel) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        ArrayList<Field> list = new ArrayList<Field>();
        list.addAll(FieldUtil.fillFields(_class.getDeclaredFields(), _accessLevel));
        if (_class.getSuperclass() != null) {
            for (Class<?> _super : ClassUtil.getAllSuperClass(_class)) {
                list.addAll(FieldUtil.fillFields(_super.getDeclaredFields(), _accessLevel));
            }
        }
        return list;
    }

    public static List<Field> getAllManyRelField(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        return FieldUtil.getAllManyRelField(_class, ReflectionAccess.PUBLIC);
    }

    public static List<Field> getAllManyRelField(Class<?> _class, ReflectionAccess accessLevel) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : FieldUtil.getAllField(_class, accessLevel)) {
            if (!Collection.class.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields;
    }

    public static List<Field> getAllOneRelField(Class<?> _class, ReflectionAccess accessLevel) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : FieldUtil.getAllField(_class, accessLevel)) {
            if (Collection.class.isAssignableFrom(field.getType()) || ValidationUtil.isPrimative(field.getType()).booleanValue()) continue;
            fields.add(field);
        }
        return fields;
    }

    public static List<Field> getAllPrimativeField(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        return FieldUtil.getAllPrimativeField(_class, ReflectionAccess.PUBLIC);
    }

    public static List<Field> getAllPrimativeField(Class<?> _class, ReflectionAccess accessLevel) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : FieldUtil.getAllField(_class, accessLevel)) {
            if (!ValidationUtil.isPrimative(field.getType()).booleanValue()) continue;
            fields.add(field);
        }
        return fields;
    }

    public static List<Field> getAllRelField(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        return FieldUtil.getAllRelField(_class, ReflectionAccess.PUBLIC);
    }

    public static List<Field> getAllRelField(Class<?> _class, ReflectionAccess accessLevel) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : FieldUtil.getAllField(_class, accessLevel)) {
            if (ValidationUtil.isPrimative(field.getType()).booleanValue()) continue;
            fields.add(field);
        }
        return fields;
    }

    public static boolean isRelField(Field _field) {
        Assertion.notNull(_field, "this field is required; it must not be null");
        return ValidationUtil.isPrimative(_field.getType()) == false;
    }
}

