/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.text;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.text.MaskFormatter;
import org.brijframework.util.asserts.Assertion;

public class StringUtil {
    public static boolean hasLength(String _text) {
        if (_text == null) {
            return false;
        }
        return !_text.isEmpty();
    }

    public static boolean hasText(Object _text) {
        Assertion.notNull(_text, "this arg is required; it must not be null");
        return _text instanceof String || _text instanceof Character;
    }

    public static boolean isEmpty(Object _text) {
        if (_text == null) {
            return true;
        }
        String s = _text.toString().trim();
        return s.length() == 0;
    }

    public static boolean isEmpty(String _text) {
        if (_text == null) {
            return true;
        }
        String s = _text.trim();
        return s.length() == 0;
    }

    public static boolean isNonEmpty(String _v) {
        return !StringUtil.isEmpty(_v);
    }

    public static boolean contains(String _search, String ... sources) {
        Assertion.notNull(sources, "this arg is required; it must not be null");
        for (String string : sources) {
            if (string == _search) {
                return true;
            }
            if (_search == null || !_search.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsEquals(Object obj1, Object obj2) {
        String s1 = new String("" + obj1);
        String s2 = new String("" + obj2);
        return s2.contentEquals(s1);
    }

    public static boolean matchIgnoreCase(Object obj1, Object obj2) {
        String s1 = new String("" + obj1);
        String s2 = new String("" + obj2);
        return s2.equalsIgnoreCase(s1);
    }

    public static boolean containsIgnoreCase(String[] stringArray, String searchString) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (searchString == null || !searchString.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(Object stringArray, Object searchString) {
        String[] dataArray;
        if (stringArray == null) {
            return false;
        }
        for (String string : dataArray = new String("" + stringArray).split(" ")) {
            if (!string.toLowerCase().contains(new String("" + searchString).toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(Object[] stringArray, Object searchString) {
        if (stringArray == null) {
            return false;
        }
        int i = 0;
        String[] textArray = new String[stringArray.length];
        for (Object obj : stringArray) {
            textArray[i++] = new String("" + obj);
        }
        for (String string : textArray) {
            if (!string.equalsIgnoreCase(new String("" + searchString))) continue;
            return true;
        }
        return false;
    }

    public static String cleanText(String _source) {
        Assertion.notNull(_source, "this arg is required; it must not be null");
        String cleanString = "";
        for (int i = 0; i < _source.length(); ++i) {
            if (!Character.isLetter(_source.charAt(i)) && !Character.isDigit(_source.charAt(i))) continue;
            cleanString = cleanString + _source.charAt(i);
        }
        return cleanString;
    }

    public static String cleanAndReplaceText(String _source, String _replaceValue) {
        Assertion.notNull(_source, "this arg is required; it must not be null");
        String cleanString = "";
        _source = _source.trim();
        for (int i = 0; i < _source.length(); ++i) {
            cleanString = Character.isLetter(_source.charAt(i)) || Character.isDigit(_source.charAt(i)) ? cleanString + _source.charAt(i) : cleanString + _replaceValue;
        }
        return cleanString;
    }

    public static String ignoreFromText(String _source, char _harToDump) {
        Assertion.notNull(_source, "this arg is required; it must not be null");
        String result = "";
        _source = _source.trim();
        for (int i = 0; i < _source.length(); ++i) {
            if (_source.charAt(i) == _harToDump) continue;
            result = result + _source.charAt(i);
        }
        return result;
    }

    public static String getTokenAtIndex(String _source, int index, String delimiter) {
        Assertion.notNull(_source, "this arg is required; it must not be null");
        String resultString = null;
        int tokenCount = 0;
        StringTokenizer TK = new StringTokenizer(_source, delimiter);
        tokenCount = TK.countTokens();
        if (index <= tokenCount) {
            for (int i = 1; i <= index; ++i) {
                String str = TK.nextToken();
                if (i != index) continue;
                resultString = str;
            }
        }
        return resultString;
    }

    public static String reverseText(String _source) {
        Assertion.notNull(_source, "this arg is required; it must not be null");
        char[] str_arr = new char[_source.length()];
        int j = 0;
        for (int i = _source.length() - 1; i >= 0; --i) {
            str_arr[j++] = _source.charAt(i);
        }
        String s = new String(str_arr);
        return s;
    }

    public static String replaceText(String _sources, String replaceText, String withText) {
        Assertion.notNull(_sources, "this arg is required; it must not be null");
        int index = _sources.indexOf(replaceText);
        if (index < 0) {
            return _sources;
        }
        return _sources.substring(0, index) + withText + StringUtil.replaceText(_sources.substring(index + replaceText.length(), _sources.length()), replaceText, withText);
    }

    public static String capitalFirst(String text) {
        Assertion.notNull(text, "this arg is required; it must not be null");
        String s1 = text.substring(0, 1).toUpperCase();
        String textCapitalized = s1 + text.substring(1);
        return textCapitalized;
    }

    public static String lowerFirst(String text) {
        Assertion.notNull(text, "this arg is required; it must not be null");
        String s1 = text.substring(0, 1).toLowerCase();
        String textCapitalized = s1 + text.substring(1);
        return textCapitalized;
    }

    public static String capitalFirstLetterText(String _textline) {
        Assertion.notNull(_textline, "this arg is required; it must not be null");
        String returnLine = "";
        for (String str : _textline.split(" ")) {
            String s1 = str.substring(0, 1).toUpperCase();
            String strCapitalized = s1 + str.substring(1);
            returnLine = returnLine + strCapitalized + " ";
        }
        return returnLine;
    }

    public static String justifyText(String _source, int length, boolean isLeftJustify, char filled) {
        int i;
        Assertion.notNull(_source, "this arg is required; it must not be null");
        char[] returnArray = new char[length];
        for (i = 0; i < length; ++i) {
            returnArray[i] = filled;
        }
        if (_source == null) {
            return String.valueOf(returnArray);
        }
        if (_source.length() <= length) {
            if (isLeftJustify) {
                for (i = 0; i < _source.length(); ++i) {
                    returnArray[i] = _source.charAt(i);
                }
            } else {
                for (i = 0; i < _source.length(); ++i) {
                    returnArray[length - 1 - i] = _source.charAt(_source.length() - 1 - i);
                }
            }
        } else if (isLeftJustify) {
            for (i = 0; i < length; ++i) {
                returnArray[i] = _source.charAt(i);
            }
        } else {
            for (i = 0; i < length; ++i) {
                returnArray[length - 1 - i] = _source.charAt(_source.length() - 1 - i);
            }
        }
        return String.valueOf(returnArray);
    }

    public static String[] split(String baseString, String splitString) {
        StringTokenizer tokenizer = new StringTokenizer(baseString, splitString);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    public static int charCountInText(String _sources, char ch) {
        int count = 0;
        char[] charArray = _sources.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != ch) continue;
            ++count;
        }
        return count;
    }

    public static String arrayToTildeText(Object[] array) {
        String text = "";
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                text = text + "" + array[i];
                if (array.length - 1 == i) continue;
                text = text + "~";
            }
        }
        return text;
    }

    public static String getCharNTimes(char c, int n) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            strBuf.append(c);
        }
        return strBuf.toString();
    }

    public static String arrayToCommaText(Object[] array) {
        String text = "";
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                text = text + "" + array[i];
                if (array.length - 1 == i) continue;
                text = text + ",";
            }
        }
        return text;
    }

    public static String getDelimString(Iterable<?> iterable, String sepStr) {
        StringBuffer strBuf = new StringBuffer();
        Iterator<?> itr = iterable.iterator();
        while (itr.hasNext()) {
            strBuf.append(itr.next());
            if (!itr.hasNext()) continue;
            strBuf.append(sepStr);
        }
        return strBuf.toString();
    }

    public static String toCamelCase(String str) {
        if (str == null || str.trim().equals("")) {
            return str;
        }
        String strNew = str.trim().toLowerCase();
        return strNew.length() >= 1 ? Character.toUpperCase(strNew.charAt(0)) + strNew.substring(1) : str;
    }

    public static String stringValue(Object obj) {
        return String.valueOf(obj);
    }

    public static String addUnderScoreBeforeUpperCaseLetter(String str) {
        if (str == null || str.trim().length() == 0) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        result.append(str.charAt(0));
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isUpperCase(str.charAt(i)) && i > 1 && Character.isLowerCase(str.charAt(i - 1))) {
                result.append("_");
            }
            result.append(str.charAt(i));
        }
        return result.toString().toUpperCase();
    }

    public static String friendlyNameForJavaVar(String string) {
        if (string.charAt(0) == '_') {
            return string;
        }
        String tempString = StringUtil.addUnderScoreBeforeUpperCaseLetter(string);
        StringBuilder builder = new StringBuilder();
        for (int counter = 0; counter < tempString.length(); ++counter) {
            if (counter == 0) {
                builder.append(tempString.charAt(counter));
                continue;
            }
            if (tempString.charAt(counter) == '_') {
                builder.append(' ');
                builder.append(tempString.charAt(counter + 1));
                ++counter;
                continue;
            }
            builder.append(Character.toLowerCase(tempString.charAt(counter)));
        }
        return builder.toString();
    }

    public static String maskString(String rawStr, char c, String format) {
        StringBuffer buffer = new StringBuffer();
        while (rawStr.length() + buffer.length() < 10) {
            buffer.append(c);
        }
        buffer.append(rawStr);
        try {
            MaskFormatter maskFormatter = new MaskFormatter(format);
            maskFormatter.setValueContainsLiteralCharacters(false);
            return maskFormatter.valueToString(buffer);
        }
        catch (ParseException parseException) {
            return buffer.toString();
        }
    }

    public static int charIndex(String sources, int start, char ch) {
        char[] chars = sources.toCharArray();
        for (int index = start; index < chars.length; ++index) {
            if (chars[index] != ch) continue;
            return index;
        }
        return -1;
    }

    public static String getOfter(StringBuffer sources, String match) {
        return StringUtil.getOfter(sources.toString(), match);
    }

    public static String getOfter(String original, String match) {
        String[] str = original.split(match);
        return str.length > 1 ? str[1] : "";
    }

    public static String getBefore(StringBuffer sources, String match) {
        return StringUtil.getOfter(sources.toString(), match);
    }

    public static String getBefore(String original, String match) {
        String[] str = original.split(match);
        return str.length > 0 ? str[0] : "";
    }

    public static String between(String original, String start, String end) {
        return StringUtil.getBefore(StringUtil.getOfter(original, start), end);
    }

    public static void main(String[] args) {
        System.out.print(StringUtil.between("/media/ramkishor/DATA3/doveloper/Workbook/abs-brijframework-web-core/target/classes/META-INF/web/context/WebContext.xml", "META-INF/", "WebContext.xml"));
    }

    public static String[] parseTilde(String objectKeys) {
        return objectKeys.split("~");
    }

    public static int indexOfIgnoreCase(String typeName, String string) {
        return 0;
    }

    public static String getCsl(ArrayList<?> toEmailAddressArray, String string) {
        return null;
    }
}

