/*
 * Decompiled with CFR 0.152.
 */
package io.armadaproject.examples;

import api.EventOuterClass;
import io.armadaproject.ArmadaClient;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamEvents {
    private static final Logger LOG = Logger.getLogger(StreamEvents.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try (ArmadaClient armadaClient = new ArmadaClient("localhost", 30002);){
            EventOuterClass.JobSetRequest jobSetRequest = EventOuterClass.JobSetRequest.newBuilder().setId("job-set-1").setQueue("example").setWatch(true).build();
            executorService.submit(() -> {
                StreamObserver<EventOuterClass.EventStreamMessage> streamObserver = new StreamObserver<EventOuterClass.EventStreamMessage>(){

                    public void onNext(EventOuterClass.EventStreamMessage value) {
                        LOG.log(Level.FINE, "event: " + value);
                    }

                    public void onError(Throwable t) {
                        LOG.log(Level.SEVERE, "error: " + t);
                    }

                    public void onCompleted() {
                        LOG.info("completed");
                    }
                };
                armadaClient.streamEvents(jobSetRequest, streamObserver);
            });
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Exception e) {
            LOG.severe("Failed to close client: " + e);
        }
        finally {
            executorService.shutdown();
        }
    }

    static {
        LOG.setLevel(Level.FINE);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINE);
        LOG.addHandler(consoleHandler);
    }
}

