/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers.fieldBuilders;

import graphql.annotations.annotationTypes.directives.activation.GraphQLDirectives;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.fieldBuilders.Builder;
import graphql.annotations.processor.util.DirectiveJavaAnnotationUtil;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DirectivesBuilder
implements Builder<GraphQLDirective[]> {
    public static final String NOT_FOUND_IN_DIRECTIVE_REGISTRY_ERROR = "No directive named %s is found in the directive registry";
    public static final String TOO_MUCH_ARGUMENTS_ERROR = "Directive '%s' is supplied with more argument values than it supports";
    public static final String DIRECTIVE_ARGUMENT_TYPE_MUST_BE_A_SCALAR = "Directive argument type must be a scalar!";
    public static final String COULD_NOT_PARSE_ARGUMENT_VALUE_TO_ARGUMENT_TYPE = "Could not parse argument value to argument type";
    private AnnotatedElement object;
    private ProcessingElementsContainer container;

    public DirectivesBuilder(AnnotatedElement object, ProcessingElementsContainer container) {
        this.object = object;
        this.container = container;
    }

    @Override
    public GraphQLDirective[] build() {
        ArrayList graphQLDirectives = new ArrayList();
        DirectiveJavaAnnotationUtil.getDirectiveAnnotations(this.object).forEach(annotation -> {
            String name = DirectiveJavaAnnotationUtil.getName(annotation);
            if (!this.container.getDirectiveRegistry().containsKey(name)) {
                throw new GraphQLAnnotationsException(String.format(NOT_FOUND_IN_DIRECTIVE_REGISTRY_ERROR, name), null);
            }
            GraphQLDirective graphQLDirective = this.transformArgs(this.container.getDirectiveRegistry().get(name).getDirective(), (Annotation)annotation);
            graphQLDirectives.add(graphQLDirective);
        });
        GraphQLDirectives directives = this.object.getAnnotation(GraphQLDirectives.class);
        if (directives != null) {
            List oldGraphQLDirectives = Arrays.stream(directives.value()).map(x -> {
                if (this.container.getDirectiveRegistry().containsKey(x.name())) {
                    return this.transformArgs(this.container.getDirectiveRegistry().get(x.name()).getDirective(), x.argumentsValues());
                }
                throw new GraphQLAnnotationsException(String.format(NOT_FOUND_IN_DIRECTIVE_REGISTRY_ERROR, x.name()), null);
            }).collect(Collectors.toList());
            graphQLDirectives.addAll(oldGraphQLDirectives);
        }
        return graphQLDirectives.toArray(new GraphQLDirective[graphQLDirectives.size()]);
    }

    private GraphQLDirective transformArgs(GraphQLDirective graphQLDirective, Annotation annotation) {
        int i;
        GraphQLDirective.Builder directiveBuilder = GraphQLDirective.newDirective((GraphQLDirective)graphQLDirective);
        directiveBuilder.clearArguments();
        List arguments = graphQLDirective.getArguments();
        if (annotation.annotationType().getDeclaredMethods().length > arguments.size()) {
            throw new GraphQLAnnotationsException(String.format(TOO_MUCH_ARGUMENTS_ERROR, graphQLDirective.getName()), null);
        }
        for (i = 0; i < annotation.annotationType().getDeclaredMethods().length; ++i) {
            this.transformArgument(annotation, directiveBuilder, (List<GraphQLArgument>)arguments, i);
        }
        for (i = annotation.annotationType().getDeclaredMethods().length; i < arguments.size(); ++i) {
            int finalI = i;
            directiveBuilder.argument(((GraphQLArgument)arguments.get(i)).transform(builder -> builder.value(((GraphQLArgument)arguments.get(finalI)).getArgumentDefaultValue().getValue())));
        }
        return directiveBuilder.build();
    }

    private GraphQLDirective transformArgs(GraphQLDirective graphQLDirective, String[] argumentValues) {
        int i;
        GraphQLDirective.Builder directiveBuilder = GraphQLDirective.newDirective((GraphQLDirective)graphQLDirective);
        directiveBuilder.clearArguments();
        List arguments = graphQLDirective.getArguments();
        if (argumentValues.length > arguments.size()) {
            throw new GraphQLAnnotationsException(String.format(TOO_MUCH_ARGUMENTS_ERROR, graphQLDirective.getName()), null);
        }
        for (i = 0; i < argumentValues.length; ++i) {
            this.transformArgument(argumentValues, directiveBuilder, (List<GraphQLArgument>)arguments, i);
        }
        for (i = argumentValues.length; i < arguments.size(); ++i) {
            int finalI = i;
            directiveBuilder.argument(((GraphQLArgument)arguments.get(i)).transform(builder -> builder.value(((GraphQLArgument)arguments.get(finalI)).getArgumentDefaultValue().getValue())));
        }
        return directiveBuilder.build();
    }

    private void transformArgument(Annotation annotation, GraphQLDirective.Builder directiveBuilder, List<GraphQLArgument> arguments, int i) {
        int finalI = i;
        GraphQLArgument graphQLArgument = arguments.get(i);
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        directiveBuilder.argument(graphQLArgument.transform(builder -> {
            if (graphQLArgument.getType() instanceof GraphQLType) {
                try {
                    methods[finalI].setAccessible(true);
                    Object argumentValue = methods[finalI].invoke((Object)annotation, new Object[0]);
                    Object value = graphQLArgument.getType() instanceof GraphQLScalarType ? ((GraphQLScalarType)graphQLArgument.getType()).getCoercing().parseValue(argumentValue) : argumentValue;
                    builder.value(value);
                }
                catch (Exception e) {
                    throw new GraphQLAnnotationsException(COULD_NOT_PARSE_ARGUMENT_VALUE_TO_ARGUMENT_TYPE, e);
                }
            } else {
                throw new GraphQLAnnotationsException(DIRECTIVE_ARGUMENT_TYPE_MUST_BE_A_SCALAR, null);
            }
        }));
    }

    private void transformArgument(String[] argumentValues, GraphQLDirective.Builder directiveBuilder, List<GraphQLArgument> arguments, int i) {
        int finalI = i;
        GraphQLArgument graphQLArgument = arguments.get(i);
        directiveBuilder.argument(graphQLArgument.transform(builder -> {
            String argumentValue = argumentValues[finalI];
            if (graphQLArgument.getType() instanceof GraphQLScalarType) {
                try {
                    Object value = ((GraphQLScalarType)graphQLArgument.getType()).getCoercing().parseValue((Object)argumentValue);
                    builder.value(value);
                }
                catch (Exception e) {
                    throw new GraphQLAnnotationsException(COULD_NOT_PARSE_ARGUMENT_VALUE_TO_ARGUMENT_TYPE, e);
                }
            } else {
                throw new GraphQLAnnotationsException(DIRECTIVE_ARGUMENT_TYPE_MUST_BE_A_SCALAR, null);
            }
        }));
    }
}

