/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.directives;

import graphql.annotations.directives.creation.DirectiveLocations;
import graphql.annotations.processor.directives.CommonPropertiesCreator;
import graphql.annotations.processor.directives.DirectiveArgumentCreator;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLDirective;
import java.lang.reflect.Field;
import java.util.Arrays;

public class DirectiveCreator {
    private DirectiveArgumentCreator directiveArgumentCreator;
    private CommonPropertiesCreator commonPropertiesCreator;

    public DirectiveCreator(DirectiveArgumentCreator directiveArgumentCreator, CommonPropertiesCreator commonPropertiesCreator) {
        this.directiveArgumentCreator = directiveArgumentCreator;
        this.commonPropertiesCreator = commonPropertiesCreator;
    }

    public GraphQLDirective getDirective(Class<?> annotatedClass) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(this.commonPropertiesCreator.getName(annotatedClass)).description(this.commonPropertiesCreator.getDescription(annotatedClass));
        Introspection.DirectiveLocation[] validLocations = this.getValidLocations(annotatedClass);
        if (validLocations == null || validLocations.length == 0) {
            throw new GraphQLAnnotationsException("No valid locations defined on directive", null);
        }
        builder.validLocations(validLocations);
        this.buildArguments(builder, annotatedClass);
        return builder.build();
    }

    private void buildArguments(GraphQLDirective.Builder builder, Class<?> annotatedClass) {
        Arrays.stream(annotatedClass.getDeclaredFields()).filter(field -> !field.isSynthetic()).forEach(field -> builder.argument(this.directiveArgumentCreator.getArgument((Field)field, annotatedClass)));
    }

    private Introspection.DirectiveLocation[] getValidLocations(Class<?> annotatedClass) {
        DirectiveLocations directiveLocationsAnnotation = annotatedClass.getAnnotation(DirectiveLocations.class);
        if (directiveLocationsAnnotation != null) {
            return directiveLocationsAnnotation.value();
        }
        return null;
    }
}

