/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.core.exception.UnexpectedException;
import net.infobank.client.core.exception.UnsupportedMessageException;
import net.infobank.client.data.code.MessageType;
import net.infobank.client.data.code.ServiceType;
import net.infobank.client.data.request.common.Fallback;
import net.infobank.client.data.request.kakao.button.Button;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class AlimtalkRequest {
    final String senderKey;
    final String msgType;
    final String to;
    final String templateCode;
    final String text;
    final List<Button> button;
    final String ref;
    final Fallback fallback;

    AlimtalkRequest(Builder builder) {
        this.senderKey = builder.senderKey;
        this.msgType = builder.msgType.toString();
        this.to = builder.to;
        this.templateCode = builder.templateCode;
        this.text = builder.text;
        this.button = builder.button;
        this.ref = builder.ref;
        this.fallback = builder.fallback;
    }

    @JsonProperty(value="senderKey")
    public String getSenderKey() {
        return this.senderKey;
    }

    @JsonProperty(value="msgType")
    public String getMsgType() {
        return this.msgType;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="templateCode")
    public String getTemplateCode() {
        return this.templateCode;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="button")
    public List<Button> getButton() {
        return this.button;
    }

    @JsonProperty(value="ref")
    public String getRef() {
        return this.ref;
    }

    @JsonProperty(value="fallback")
    public Fallback getFallback() {
        return this.fallback;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException jpe) {
            throw new UnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    public static class Builder {
        private String senderKey;
        private MessageType msgType;
        private String to;
        private String templateCode;
        private String text;
        private String ref;
        private List<Button> button = new ArrayList<Button>();
        private Fallback fallback;

        Builder() {
        }

        public Builder senderKey(String senderKey) {
            this.senderKey = senderKey;
            return this;
        }

        public Builder msgType(MessageType msgType) {
            this.msgType = msgType;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder templateCode(String templateCode) {
            this.templateCode = templateCode;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder addButton(Button button) {
            this.button.add(button);
            return this;
        }

        public Builder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public Builder fallback(Fallback fallback) {
            this.fallback = fallback;
            return this;
        }

        public AlimtalkRequest build() {
            if (this.senderKey == null) {
                throw new MissingFieldException("senderKey field must not be null");
            }
            if (this.msgType == null) {
                throw new MissingFieldException("msgType field must not be null");
            }
            if (this.to == null) {
                throw new MissingFieldException("to field must not be null");
            }
            if (this.templateCode == null) {
                throw new MissingFieldException("templateCode field must not be null");
            }
            if (this.text == null) {
                throw new MissingFieldException("text field must not be null");
            }
            if (!ServiceType.ALIMTALK.supports(this.msgType)) {
                throw new UnsupportedMessageException("This msgType is not supported by the ALIMTALK");
            }
            return new AlimtalkRequest(this);
        }
    }
}

