/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import net.infobank.client.core.exception.UnexpectedException;
import net.infobank.client.data.request.message.AlimtalkMessage;
import net.infobank.client.data.request.message.FriendtalkMessage;
import net.infobank.client.data.request.message.MmsMessage;
import net.infobank.client.data.request.message.RcsMessage;
import net.infobank.client.data.request.message.SmsMessage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class MessageFormRequest {
    final List<Object> messageForm;
    final String formId;
    String method;

    MessageFormRequest(Builder builder) {
        this.messageForm = builder.messageForm;
        this.formId = builder.formId;
    }

    @JsonProperty(value="messageForm")
    public List<Object> getMessageForm() {
        return this.messageForm;
    }

    @JsonIgnore
    public String getFormId() {
        return this.formId;
    }

    @JsonIgnore
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException jpe) {
            throw new UnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    public static class Builder {
        private List<Object> messageForm = new ArrayList<Object>();
        private String formId;

        Builder() {
        }

        public Builder formId(String formId) {
            this.formId = formId;
            return this;
        }

        public Builder addMessage(SmsMessage sms) {
            this.messageForm.add(sms);
            return this;
        }

        public Builder addMessage(MmsMessage mms) {
            this.messageForm.add(mms);
            return this;
        }

        public Builder addMessage(RcsMessage rcs) {
            this.messageForm.add(rcs);
            return this;
        }

        public Builder addMessage(AlimtalkMessage alimtalk) {
            this.messageForm.add(alimtalk);
            return this;
        }

        public Builder addMessage(FriendtalkMessage friendtalk) {
            this.messageForm.add(friendtalk);
            return this;
        }

        public MessageFormRequest build() {
            return new MessageFormRequest(this);
        }
    }
}

