/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.core.exception.UnexpectedException;
import net.infobank.client.data.request.common.Destination;
import net.infobank.client.data.request.message.AlimtalkMessage;
import net.infobank.client.data.request.message.BrandMessage;
import net.infobank.client.data.request.message.FriendtalkMessage;
import net.infobank.client.data.request.message.MmsMessage;
import net.infobank.client.data.request.message.RcsMessage;
import net.infobank.client.data.request.message.SmsMessage;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class OmniRequest {
    final List<Destination> destinations;
    final List<Object> messageFlow;
    final String messageForm;
    final String paymentCode;
    final String ref;

    OmniRequest(Builder builder) {
        this.destinations = builder.destinations;
        this.messageFlow = builder.messageFlow;
        this.messageForm = builder.messageForm;
        this.paymentCode = builder.paymentCode;
        this.ref = builder.ref;
    }

    @JsonProperty(value="destinations")
    public List<Destination> getDestinations() {
        return this.destinations;
    }

    @JsonProperty(value="messageFlow")
    public List<Object> getMessageFlow() {
        return this.messageFlow;
    }

    @JsonProperty(value="messageForm")
    public String getMessageForm() {
        return this.messageForm;
    }

    @JsonProperty(value="paymentCode")
    public String getPaymentCode() {
        return this.paymentCode;
    }

    @JsonProperty(value="ref")
    public String getRef() {
        return this.ref;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException jpe) {
            throw new UnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    public static class Builder {
        private List<Destination> destinations = new ArrayList<Destination>();
        private List<Object> messageFlow = new ArrayList<Object>();
        private String messageForm;
        private String paymentCode;
        private String ref;

        Builder() {
        }

        public Builder addDestination(Destination destination) {
            this.destinations.add(destination);
            return this;
        }

        public Builder messageForm(String messageForm) {
            this.messageForm = messageForm;
            return this;
        }

        public Builder addMessage(SmsMessage sms) {
            this.messageFlow.add(sms);
            return this;
        }

        public Builder addMessage(MmsMessage mms) {
            this.messageFlow.add(mms);
            return this;
        }

        public Builder addMessage(RcsMessage rcs) {
            this.messageFlow.add(rcs);
            return this;
        }

        public Builder addMessage(AlimtalkMessage alimtalk) {
            this.messageFlow.add(alimtalk);
            return this;
        }

        public Builder addMessage(FriendtalkMessage friendtalk) {
            this.messageFlow.add(friendtalk);
            return this;
        }

        public Builder addMessage(BrandMessage brandmessage) {
            this.messageFlow.add(brandmessage);
            return this;
        }

        public Builder paymentCode(String paymentCode) {
            this.paymentCode = paymentCode;
            return this;
        }

        public Builder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public OmniRequest build() {
            if (this.destinations.size() == 0) {
                throw new MissingFieldException("destinations field must not be null");
            }
            return new OmniRequest(this);
        }
    }
}

