/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.service.regi;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.infobank.client.core.AbstractMethod;
import net.infobank.client.core.HttpWrapper;
import net.infobank.client.core.exception.ErrorResponseException;
import net.infobank.client.data.request.FileRequest;
import net.infobank.client.data.response.FileResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.tika.Tika;

public class FileService
extends AbstractMethod<FileRequest, FileResponse> {
    private static final String PATH = "/v1/file";
    private final Tika tika = new Tika();

    public FileService(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    public RequestBuilder makeRequest(FileRequest file) throws UnsupportedEncodingException {
        RequestBuilder request;
        String subPath = "/" + file.getServiceType().toString();
        if (file.getMsgType() != null) {
            subPath = subPath + "/" + file.getMsgType();
        }
        if (file.getSubType() != null) {
            subPath = subPath + "/" + file.getSubType();
        }
        try {
            String mimeType = this.tika.detect(file.getFile());
            ContentType contentType = ContentType.create(mimeType == null ? "application/octet-stream" : mimeType);
            request = RequestBuilder.post(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH + subPath).setHeader("Accept", "application/json").setEntity(MultipartEntityBuilder.create().addPart("file", new FileBody(file.getFile(), contentType)).build());
        }
        catch (IOException e) {
            throw new UnsupportedEncodingException();
        }
        return request;
    }

    @Override
    public FileResponse parseResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return FileResponse.fromJson(basicResponseHandler.handleResponse(response));
        }
        throw ErrorResponseException.fromHttpResponse(response);
    }
}

