/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.service.regi;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.infobank.client.core.AbstractMethod;
import net.infobank.client.core.HttpWrapper;
import net.infobank.client.core.exception.ErrorResponseException;
import net.infobank.client.data.request.MessageFormRequest;
import net.infobank.client.data.response.MessageFormResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class MessageFormService
extends AbstractMethod<MessageFormRequest, MessageFormResponse> {
    private static final String PATH = "/v1/form";

    public MessageFormService(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    public RequestBuilder makeRequest(MessageFormRequest form) throws UnsupportedEncodingException {
        String method = form.getMethod();
        RequestBuilder request = null;
        switch (method) {
            case "POST": {
                request = RequestBuilder.post(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH).setHeader("Content-Type", "application/json").setHeader("Accept", "application/json").setEntity(new StringEntity(form.toJson(), ContentType.APPLICATION_JSON));
                break;
            }
            case "PUT": {
                request = RequestBuilder.put(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH + "/" + form.getFormId()).setHeader("Content-Type", "application/json").setHeader("Accept", "application/json").setEntity(new StringEntity(form.toJson(), ContentType.APPLICATION_JSON));
                break;
            }
            case "GET": {
                request = RequestBuilder.get(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH + "/" + form.getFormId()).setHeader("Accept", "application/json");
                break;
            }
            case "DELETE": {
                request = RequestBuilder.delete(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH + "/" + form.getFormId()).setHeader("Accept", "application/json");
                break;
            }
        }
        return request;
    }

    @Override
    public MessageFormResponse parseResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return MessageFormResponse.fromJson(basicResponseHandler.handleResponse(response));
        }
        throw ErrorResponseException.fromHttpResponse(response);
    }
}

