/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.service.report;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.infobank.client.core.AbstractMethod;
import net.infobank.client.core.HttpWrapper;
import net.infobank.client.core.exception.ErrorResponseException;
import net.infobank.client.data.request.ReportPollingRequest;
import net.infobank.client.data.response.ReportPollingResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

public class ReportPollingService
extends AbstractMethod<ReportPollingRequest, ReportPollingResponse> {
    private static final String PATH = "/v1/report/polling";

    public ReportPollingService(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    public RequestBuilder makeRequest(ReportPollingRequest report) throws UnsupportedEncodingException {
        String method = report.getMethod();
        RequestBuilder request = null;
        switch (method) {
            case "GET": {
                request = RequestBuilder.get(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH).setHeader("Accept", "application/json");
                break;
            }
            case "DELETE": {
                request = RequestBuilder.delete(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH + "/" + report.getReportId()).setHeader("Accept", "application/json");
                break;
            }
        }
        return request;
    }

    @Override
    public ReportPollingResponse parseResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return ReportPollingResponse.fromJson(basicResponseHandler.handleResponse(response));
        }
        throw ErrorResponseException.fromHttpResponse(response);
    }
}

