/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.service.send;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.infobank.client.core.AbstractMethod;
import net.infobank.client.core.HttpWrapper;
import net.infobank.client.core.exception.ErrorResponseException;
import net.infobank.client.data.request.OmniRequest;
import net.infobank.client.data.response.OmniResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class OmniService
extends AbstractMethod<OmniRequest, OmniResponse> {
    private static final String PATH = "/v1/send/omni";

    public OmniService(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    public RequestBuilder makeRequest(OmniRequest omni) throws UnsupportedEncodingException {
        RequestBuilder request = RequestBuilder.post(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH).setHeader("Content-Type", "application/json").setHeader("Accept", "application/json").setEntity(new StringEntity(omni.toJson(), ContentType.APPLICATION_JSON));
        return request;
    }

    @Override
    public OmniResponse parseResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return OmniResponse.fromJson(basicResponseHandler.handleResponse(response));
        }
        throw ErrorResponseException.fromHttpResponse(response);
    }
}

