/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.instrument;

import io.github.interacto.binding.WidgetBinding;
import io.github.interacto.command.Command;
import io.github.interacto.instrument.Instrument;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class InstrumentImpl<T extends WidgetBinding<? extends Command>>
implements Instrument<T> {
    protected boolean activated = false;
    protected final List<T> bindings = new ArrayList<T>();
    protected boolean modified = false;
    protected final Set<Disposable> disposables = new HashSet<Disposable>();
    protected boolean configured = false;

    protected void addDisposable(Disposable disposable) {
        if (disposable != null) {
            this.disposables.add(disposable);
        }
    }

    @Override
    public int getNbWidgetBindings() {
        return this.bindings.size();
    }

    @Override
    public boolean hasWidgetBindings() {
        return this.getNbWidgetBindings() > 0;
    }

    @Override
    public List<T> getWidgetBindings() {
        return this.bindings;
    }

    protected abstract void configureBindings();

    public void addBinding(T binding) {
        if (binding != null) {
            this.bindings.add(binding);
            binding.setActivated(this.isActivated());
        }
    }

    @Override
    public void clearEvents() {
        this.bindings.forEach(binding -> binding.clearEvents());
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public void setActivated(boolean toBeActivated) {
        this.activated = toBeActivated;
        if (toBeActivated && !this.configured) {
            this.configured = true;
            this.configureBindings();
        } else {
            this.bindings.forEach(binding -> binding.setActivated(toBeActivated));
        }
    }

    @Override
    public void save(boolean generalPreferences, String nsURI, Document document, Element root) {
    }

    @Override
    public void load(boolean generalPreferences, String nsURI, Element meta) {
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean isModified) {
        this.modified = isModified;
    }

    @Override
    public void reinit() {
    }

    @Override
    public void uninstallBindings() {
        this.bindings.forEach(binding -> binding.uninstallBinding());
        this.bindings.clear();
        this.disposables.stream().filter(d -> !d.isDisposed()).forEach(d -> d.dispose());
        this.disposables.clear();
    }
}

