/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen.loader;

import io.gorules.zen.loader.DecisionLoader;
import io.gorules.zen_engine.JsonBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public class ClasspathDecisionLoader
implements DecisionLoader {
    private final String rootPath;

    public ClasspathDecisionLoader(String rootPath) {
        Object normalized = rootPath;
        if (((String)normalized).startsWith("/")) {
            normalized = ((String)normalized).substring(1);
        }
        if (!((String)normalized).isEmpty() && !((String)normalized).endsWith("/")) {
            normalized = (String)normalized + "/";
        }
        this.rootPath = normalized;
    }

    @Override
    public CompletableFuture<JsonBuffer> load(String key) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String resourcePath = this.rootPath + key;
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
                if (is == null) {
                    throw new RuntimeException("Decision not found in classpath: " + resourcePath);
                }
                byte[] content = is.readAllBytes();
                is.close();
                JsonBuffer buffer = new JsonBuffer(content);
                return buffer;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load decision from classpath: " + key, e);
            }
        });
    }

    public String getRootPath() {
        return this.rootPath;
    }
}

