/*
 * Decompiled with CFR 0.152.
 */
package io.github.julwas797.esaapi.api.impl;

import io.github.julwas797.esaapi.api.DataSource;
import io.github.julwas797.esaapi.api.handler.APIHandler;
import io.github.julwas797.esaapi.common.APIEntry;
import io.github.julwas797.esaapi.common.SchoolEntry;
import io.github.julwas797.esaapi.common.SmogEntry;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class APIDataSource
implements DataSource {
    private List<APIEntry> apiEntryList = new ArrayList<APIEntry>();

    public List<APIEntry> getApiEntryList() {
        return this.apiEntryList;
    }

    @Override
    public void refreshEntries() {
        JSONArray apiJsonEntries = APIHandler.getInstance().getJsonApiDataArray();
        if (!apiJsonEntries.isEmpty()) {
            ArrayList<APIEntry> temporaryList = new ArrayList<APIEntry>();
            apiJsonEntries.forEach(entry -> {
                JSONObject newEntry = new JSONObject(entry.toString());
                SchoolEntry schoolEntry = new SchoolEntry(newEntry.getJSONObject("school"));
                SmogEntry smogEntry = new SmogEntry(newEntry.getJSONObject("data"));
                temporaryList.add(new APIEntry(schoolEntry, smogEntry));
            });
            this.apiEntryList = temporaryList;
        }
    }
}

