package io.github.julwas797.esaapi.api.impl;

import io.github.julwas797.esaapi.api.DataSource;
import io.github.julwas797.esaapi.api.handler.APIHandler;
import io.github.julwas797.esaapi.common.APIEntry;
import io.github.julwas797.esaapi.common.SchoolEntry;
import io.github.julwas797.esaapi.common.SmogEntry;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Basic data source of air pollution data. <br>
 * It does not include any automatic refresh of data, so you should proceed with caution. <br>
 * For {@link DataSource} that contains refresh while initialization, please check {@link APIAutoDataSource}
 */
public class APIDataSource implements DataSource {
    /**
     * List containing {@link APIEntry}, obtained by {@link #getApiEntryList()} and fetched using {@link #refreshEntries()}
     */
    private List<APIEntry> apiEntryList = new ArrayList<>();

    /**
     * Returns a list of {@link APIEntry}
     *
     * @return List containing {@link APIEntry}
     */
    public List<APIEntry> getApiEntryList() {
        return apiEntryList;
    }

    /**
     * Method used to refresh entries in {@link #apiEntryList}
     */
    public void refreshEntries() {
        JSONArray apiJsonEntries = APIHandler.getInstance().getJsonApiDataArray();
        List<APIEntry> temporaryList = new ArrayList<>();

        for (int i = 0; i < apiJsonEntries.length(); i++) {
            JSONObject newEntry = apiJsonEntries.getJSONObject(i);
            SchoolEntry schoolEntry = new SchoolEntry(newEntry.getJSONObject("school"));
            SmogEntry smogEntry = new SmogEntry(newEntry.getJSONObject("data"));
            temporaryList.add(new APIEntry(schoolEntry, smogEntry));
        }

        this.apiEntryList = temporaryList;
    }
}
