/*
 * Decompiled with CFR 0.152.
 */
package io.github.julwas797.esaapi.common;

import io.github.julwas797.esaapi.common.Coordinates;
import io.github.julwas797.esaapi.format.PostalCodeFormatter;
import java.util.Objects;
import org.json.JSONObject;

public class SchoolEntry {
    private final String name;
    private final String street;
    private final int postalCode;
    private final String city;
    private final Coordinates coordinates;

    public SchoolEntry(String name, String street, int postalCode, String city, Coordinates coordinates) {
        this.name = name;
        this.street = street;
        this.postalCode = postalCode;
        this.city = city;
        this.coordinates = coordinates;
    }

    public SchoolEntry(JSONObject jsonObject) {
        this(jsonObject.optString("name"), jsonObject.opt("street").toString(), PostalCodeFormatter.getInstance().format(jsonObject), jsonObject.optString("city"), jsonObject.optDouble("longitude"), jsonObject.optDouble("latitude"));
    }

    public SchoolEntry(String name, String street, int postalCode, String city, double longitude, double latitude) {
        this(name, street, postalCode, city, new Coordinates(longitude, latitude));
    }

    public String getName() {
        return this.name;
    }

    public String getStreet() {
        return this.street;
    }

    public int getPostalCode() {
        return this.postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String toString() {
        return "SchoolEntry{name='" + this.name + '\'' + ", street='" + this.street + '\'' + ", postalCode=" + this.postalCode + ", city='" + this.city + '\'' + ", coordinates=" + this.coordinates + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchoolEntry that = (SchoolEntry)o;
        return this.postalCode == that.postalCode && Objects.equals(this.name, that.name) && Objects.equals(this.street, that.street) && Objects.equals(this.city, that.city) && Objects.equals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.street, this.postalCode, this.city, this.coordinates);
    }
}

