/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt.impls;

import io.github.kloping.spt.interfaces.Logger;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.fusesource.jansi.Ansi;

public class LoggerImpl
implements Logger {
    public static final Color NORMAL_LOW_COLOR = new Color(116, 117, 116, 224);
    public static final Color NORMAL_COLOR = new Color(202, 206, 199, 247);
    public static final Color INFO_COLOR = new Color(24, 220, 85, 247);
    public static final Color DEBUG_COLOR = new Color(234, 213, 103, 247);
    public static final Color ERROR_COLOR = new Color(224, 17, 106, 247);
    private int logLevel = 0;
    private SimpleDateFormat df = new SimpleDateFormat("MM/dd-HH:mm:ss:SSS");
    private String prefix = "[github.kloping.ST]";
    private File file;
    private BufferedWriter writer = null;

    @Override
    public void setOutFile(String path) {
        this.file = new File(path);
    }

    @Override
    public void setFormat(SimpleDateFormat format) {
        this.df = format;
    }

    @Override
    public void Log(String mess, Integer level) {
        String out;
        block21: {
            String log;
            block20: {
                log = null;
                out = null;
                try {
                    log = "[" + this.df.format(new Date()) + "]=>" + mess;
                    switch (level) {
                        case 0: {
                            log = "[Normal]" + log;
                            break;
                        }
                        case 1: {
                            log = "[Info]  " + log;
                            break;
                        }
                        case 2: {
                            log = "[Debug] " + log;
                            break;
                        }
                        case -1: {
                            log = "[Error] " + log;
                            break;
                        }
                    }
                    log = this.prefix + log;
                    out = null;
                    if (level == 0) {
                        out = Ansi.ansi().fgRgb(NORMAL_COLOR.getRGB()).a(log).reset().toString();
                    } else if (level == 1) {
                        out = Ansi.ansi().fgRgb(INFO_COLOR.getRGB()).a(log).reset().toString();
                    } else if (level == 2) {
                        out = Ansi.ansi().fgRgb(DEBUG_COLOR.getRGB()).a(log).reset().toString();
                    } else if (level == -1) {
                        out = Ansi.ansi().fgRgb(ERROR_COLOR.getRGB()).a(log).reset().toString();
                    }
                }
                catch (Exception e) {
                    if (level != -1 && level < this.logLevel) break block20;
                    e.printStackTrace();
                }
            }
            try {
                BufferedWriter writer = this.getWriter();
                if (writer == null) break block21;
                try {
                    log = log.replaceAll("\\\u001b\\[38\\;2\\;[0-9]+\\;[0-9]+\\;[0-9]+m", "").replaceAll("\\\u001b\\[m", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                writer.write(log);
                writer.newLine();
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (level != -1 && level < this.logLevel) {
            return;
        }
        System.out.println(out);
    }

    private BufferedWriter getWriter() {
        if (this.file != null && this.writer == null) {
            try {
                this.writer = new BufferedWriter(new FileWriter(this.file, true));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.writer;
    }

    @Override
    public int setLogLevel(int level) {
        this.logLevel = level;
        return this.logLevel;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

