/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.ex;

import io.github.kloping.judge.Judge;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.entities.ex.BaseKeyVals;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.impl.MessagePacket;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;
import org.jsoup.helper.HttpConnection;

public class Image
implements SendAble {
    private String url;
    private byte[] bytes;
    private String type = "image/jpeg";
    private String name = UUID.randomUUID() + ".jpg";

    public Image(byte[] bytes) {
        this.bytes = bytes;
    }

    public Image(String url) {
        this.url = url;
    }

    public Image(byte[] bytes, String type) {
        this.bytes = bytes;
        this.type = type;
    }

    public Image(byte[] bytes, String type, String name) {
        this.bytes = bytes;
        this.type = type;
        this.name = name;
    }

    @Override
    public ActionResult send(SenderAndCidMidGetter er) {
        if (this.getBytes() != null) {
            BaseKeyVals keyVals = new BaseKeyVals();
            if (er.getMid() != null) {
                HttpConnection.KeyVal v0 = HttpConnection.KeyVal.create((String)"msg_id", (String)er.getMid());
                v0.contentType("text/plain");
                keyVals.add(v0);
            }
            HttpConnection.KeyVal v1 = HttpConnection.KeyVal.create((String)"file_image", (String)this.name);
            v1.inputStream((InputStream)new ByteArrayInputStream(this.bytes));
            v1.contentType(this.type);
            keyVals.add(v1);
            return er.getBot().messageBase.send(er.getCid(), Channel.SEND_FORM_DATA_HEADERS, keyVals);
        }
        MessagePacket packet = new MessagePacket();
        if (Judge.isNotEmpty((String)this.getUrl())) {
            packet.setImage(this.getUrl());
        }
        return er.send(packet);
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        if (!Arrays.equals(this.getBytes(), other.getBytes())) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Image;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBytes());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "Image(url=" + this.getUrl() + ", bytes=" + Arrays.toString(this.getBytes()) + ", type=" + this.getType() + ", name=" + this.getName() + ")";
    }
}

