/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.csource.common.Base64;
import org.csource.common.MyException;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.DownloadCallback;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.csource.fastdfs.UploadCallback;
import org.csource.fastdfs.UploadStream;
import org.csource.fastdfs.pool.Connection;

public class StorageClient {
    public static final Base64 base64 = new Base64('-', '_', '.', 0);
    protected TrackerServer trackerServer;
    protected StorageServer storageServer;
    protected byte errno;

    public StorageClient() {
        this.trackerServer = null;
        this.storageServer = null;
    }

    public StorageClient(TrackerServer trackerServer) {
        this.trackerServer = trackerServer;
        this.storageServer = null;
    }

    public StorageClient(TrackerServer trackerServer, StorageServer storageServer) {
        this.trackerServer = trackerServer;
        this.storageServer = storageServer;
    }

    public byte getErrorCode() {
        return this.errno;
    }

    public String[] upload_file(String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_file(group_name, local_filename, file_ext_name, meta_list);
    }

    protected String[] upload_file(String group_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        int cmd = 11;
        return this.upload_file((byte)11, group_name, local_filename, file_ext_name, meta_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] upload_file(byte cmd, String group_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        int nPos;
        File f = new File(local_filename);
        FileInputStream fis = new FileInputStream(f);
        if (file_ext_name == null && (nPos = local_filename.lastIndexOf(46)) > 0 && local_filename.length() - nPos <= 7) {
            file_ext_name = local_filename.substring(nPos + 1);
        }
        try {
            String[] stringArray = this.do_upload_file(cmd, group_name, null, null, file_ext_name, f.length(), new UploadStream(fis, f.length()), meta_list);
            return stringArray;
        }
        finally {
            fis.close();
        }
    }

    public String[] upload_file(byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_file(group_name, file_buff, offset, length, file_ext_name, meta_list);
    }

    public String[] upload_file(String group_name, byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)11, group_name, null, null, file_ext_name, length, new UploadBuff(file_buff, offset, length), meta_list);
    }

    public String[] upload_file(byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_file(group_name, file_buff, 0, file_buff.length, file_ext_name, meta_list);
    }

    public String[] upload_file(String group_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)11, group_name, null, null, file_ext_name, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length), meta_list);
    }

    public String[] upload_file(String group_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String master_filename = null;
        String prefix_name = null;
        return this.do_upload_file((byte)11, group_name, master_filename, prefix_name, file_ext_name, file_size, callback, meta_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] upload_file(String group_name, String master_filename, String prefix_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        int nPos;
        if (group_name == null || group_name.length() == 0 || master_filename == null || master_filename.length() == 0 || prefix_name == null) {
            throw new MyException("invalid arguement");
        }
        File f = new File(local_filename);
        FileInputStream fis = new FileInputStream(f);
        if (file_ext_name == null && (nPos = local_filename.lastIndexOf(46)) > 0 && local_filename.length() - nPos <= 7) {
            file_ext_name = local_filename.substring(nPos + 1);
        }
        try {
            String[] stringArray = this.do_upload_file((byte)21, group_name, master_filename, prefix_name, file_ext_name, f.length(), new UploadStream(fis, f.length()), meta_list);
            return stringArray;
        }
        finally {
            fis.close();
        }
    }

    public String[] upload_file(String group_name, String master_filename, String prefix_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        if (group_name == null || group_name.length() == 0 || master_filename == null || master_filename.length() == 0 || prefix_name == null) {
            throw new MyException("invalid arguement");
        }
        return this.do_upload_file((byte)21, group_name, master_filename, prefix_name, file_ext_name, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length), meta_list);
    }

    public String[] upload_file(String group_name, String master_filename, String prefix_name, byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        if (group_name == null || group_name.length() == 0 || master_filename == null || master_filename.length() == 0 || prefix_name == null) {
            throw new MyException("invalid arguement");
        }
        return this.do_upload_file((byte)21, group_name, master_filename, prefix_name, file_ext_name, length, new UploadBuff(file_buff, offset, length), meta_list);
    }

    public String[] upload_file(String group_name, String master_filename, String prefix_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)21, group_name, master_filename, prefix_name, file_ext_name, file_size, callback, meta_list);
    }

    public String[] upload_appender_file(String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_appender_file(group_name, local_filename, file_ext_name, meta_list);
    }

    protected String[] upload_appender_file(String group_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        int cmd = 23;
        return this.upload_file((byte)23, group_name, local_filename, file_ext_name, meta_list);
    }

    public String[] upload_appender_file(byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_appender_file(group_name, file_buff, offset, length, file_ext_name, meta_list);
    }

    public String[] upload_appender_file(String group_name, byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)23, group_name, null, null, file_ext_name, length, new UploadBuff(file_buff, offset, length), meta_list);
    }

    public String[] upload_appender_file(byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_appender_file(group_name, file_buff, 0, file_buff.length, file_ext_name, meta_list);
    }

    public String[] upload_appender_file(String group_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)23, group_name, null, null, file_ext_name, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length), meta_list);
    }

    public String[] upload_appender_file(String group_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String master_filename = null;
        String prefix_name = null;
        return this.do_upload_file((byte)23, group_name, master_filename, prefix_name, file_ext_name, file_size, callback, meta_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append_file(String group_name, String appender_filename, String local_filename) throws IOException, MyException {
        File f = new File(local_filename);
        try (FileInputStream fis = new FileInputStream(f);){
            int n = this.do_append_file(group_name, appender_filename, f.length(), new UploadStream(fis, f.length()));
            return n;
        }
    }

    public int append_file(String group_name, String appender_filename, byte[] file_buff) throws IOException, MyException {
        return this.do_append_file(group_name, appender_filename, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length));
    }

    public int append_file(String group_name, String appender_filename, byte[] file_buff, int offset, int length) throws IOException, MyException {
        return this.do_append_file(group_name, appender_filename, length, new UploadBuff(file_buff, offset, length));
    }

    public int append_file(String group_name, String appender_filename, long file_size, UploadCallback callback) throws IOException, MyException {
        return this.do_append_file(group_name, appender_filename, file_size, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int modify_file(String group_name, String appender_filename, long file_offset, String local_filename) throws IOException, MyException {
        File f = new File(local_filename);
        try (FileInputStream fis = new FileInputStream(f);){
            int n = this.do_modify_file(group_name, appender_filename, file_offset, f.length(), new UploadStream(fis, f.length()));
            return n;
        }
    }

    public int modify_file(String group_name, String appender_filename, long file_offset, byte[] file_buff) throws IOException, MyException {
        return this.do_modify_file(group_name, appender_filename, file_offset, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length));
    }

    public int modify_file(String group_name, String appender_filename, long file_offset, byte[] file_buff, int buffer_offset, int buffer_length) throws IOException, MyException {
        return this.do_modify_file(group_name, appender_filename, file_offset, buffer_length, new UploadBuff(file_buff, buffer_offset, buffer_length));
    }

    public int modify_file(String group_name, String appender_filename, long file_offset, long modify_size, UploadCallback callback) throws IOException, MyException {
        return this.do_modify_file(group_name, appender_filename, file_offset, modify_size, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] regenerate_appender_filename(String group_name, String appender_filename) throws IOException, MyException {
        Connection connection = null;
        if (group_name == null || group_name.length() == 0 || appender_filename == null || appender_filename.length() == 0) {
            this.errno = (byte)22;
            return null;
        }
        boolean bNewStorageServer = this.newUpdatableStorageConnection(group_name, appender_filename);
        try {
            connection = this.storageServer.getConnection();
            byte[] appenderFilenameBytes = appender_filename.getBytes(ClientGlobal.g_charset);
            long body_len = appenderFilenameBytes.length;
            byte[] header = ProtoCommon.packHeader((byte)38, body_len, (byte)0);
            byte[] wholePkg = new byte[(int)((long)header.length + body_len)];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            int offset = header.length;
            System.arraycopy(appenderFilenameBytes, 0, wholePkg, offset, appenderFilenameBytes.length);
            offset += appenderFilenameBytes.length;
            OutputStream out = connection.getOutputStream();
            out.write(wholePkg);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                String[] stringArray = null;
                return stringArray;
            }
            if (pkgInfo.body.length <= 16) {
                throw new MyException("body length: " + pkgInfo.body.length + " <= 16");
            }
            String new_group_name = new String(pkgInfo.body, 0, 16).trim();
            String remote_filename = new String(pkgInfo.body, 16, pkgInfo.body.length - 16);
            String[] results = new String[]{new_group_name, remote_filename};
            String[] stringArray = results;
            return stringArray;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String[] do_upload_file(byte cmd, String group_name, String master_filename, String prefix_name, String file_ext_name, long file_size, UploadCallback callback, NameValuePair[] meta_list) throws IOException, MyException {
        connection = null;
        bUploadSlave = group_name != null && group_name.length() > 0 && master_filename != null && master_filename.length() > 0 && prefix_name != null;
        bNewStorageServer = bUploadSlave != false ? this.newUpdatableStorageConnection(group_name, master_filename) : this.newWritableStorageConnection(group_name);
        try {
            connection = this.storageServer.getConnection();
            ext_name_bs = new byte[6];
            Arrays.fill(ext_name_bs, (byte)0);
            if (file_ext_name != null && file_ext_name.length() > 0) {
                bs = file_ext_name.getBytes(ClientGlobal.g_charset);
                ext_name_len = bs.length;
                if (ext_name_len > 6) {
                    ext_name_len = 6;
                }
                System.arraycopy(bs, 0, ext_name_bs, 0, ext_name_len);
            }
            if (bUploadSlave) {
                masterFilenameBytes = master_filename.getBytes(ClientGlobal.g_charset);
                sizeBytes = new byte[16];
                body_len = (long)(sizeBytes.length + 16 + 6 + masterFilenameBytes.length) + file_size;
                hexLenBytes = ProtoCommon.long2buff(master_filename.length());
                System.arraycopy(hexLenBytes, 0, sizeBytes, 0, hexLenBytes.length);
                offset = hexLenBytes.length;
            } else {
                masterFilenameBytes = null;
                sizeBytes = new byte[9];
                body_len = (long)(sizeBytes.length + 6) + file_size;
                sizeBytes[0] = (byte)this.storageServer.getStorePathIndex();
                offset = 1;
            }
            hexLenBytes = ProtoCommon.long2buff(file_size);
            System.arraycopy(hexLenBytes, 0, sizeBytes, offset, hexLenBytes.length);
            out = connection.getOutputStream();
            header = ProtoCommon.packHeader(cmd, body_len, (byte)0);
            wholePkg = new byte[(int)((long)header.length + body_len - file_size)];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(sizeBytes, 0, wholePkg, header.length, sizeBytes.length);
            offset = header.length + sizeBytes.length;
            if (bUploadSlave) {
                prefix_name_bs = new byte[16];
                bs = prefix_name.getBytes(ClientGlobal.g_charset);
                prefix_name_len = bs.length;
                Arrays.fill(prefix_name_bs, (byte)0);
                if (prefix_name_len > 16) {
                    prefix_name_len = 16;
                }
                if (prefix_name_len > 0) {
                    System.arraycopy(bs, 0, prefix_name_bs, 0, prefix_name_len);
                }
                System.arraycopy(prefix_name_bs, 0, wholePkg, offset, prefix_name_bs.length);
                offset += prefix_name_bs.length;
            }
            System.arraycopy(ext_name_bs, 0, wholePkg, offset, ext_name_bs.length);
            offset += ext_name_bs.length;
            if (bUploadSlave) {
                System.arraycopy(masterFilenameBytes, 0, wholePkg, offset, masterFilenameBytes.length);
                offset += masterFilenameBytes.length;
            }
            out.write(wholePkg);
            this.errno = (byte)callback.send(out);
            if (this.errno != 0) {
                prefix_name_bs = null;
                return prefix_name_bs;
            }
            pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                bs = null;
                return bs;
            }
            if (pkgInfo.body.length <= 16) {
                throw new MyException("body length: " + pkgInfo.body.length + " <= 16");
            }
            new_group_name = new String(pkgInfo.body, 0, 16).trim();
            remote_filename = new String(pkgInfo.body, 16, pkgInfo.body.length - 16);
            results = new String[]{new_group_name, remote_filename};
            if (meta_list == null || meta_list.length == 0) {
                prefix_name_len = results;
                return prefix_name_len;
            }
            result = 0;
            try {
                result = this.set_metadata(new_group_name, remote_filename, meta_list, (byte)79);
                ** if (result == 0) goto lbl-1000
            }
            catch (IOException ex) {
                try {
                    result = 5;
                    throw ex;
                }
                catch (Throwable var29_33) {
                    if (result != 0) {
                        this.errno = (byte)result;
                        this.delete_file(new_group_name, remote_filename);
                        var30_34 = null;
                        this.releaseConnection(connection, bNewStorageServer);
                        return var30_34;
                    }
                    throw var29_33;
                }
            }
lbl-1000:
            // 1 sources

            {
                this.errno = (byte)result;
                this.delete_file(new_group_name, remote_filename);
                var28_30 = null;
                return var28_30;
            }
lbl-1000:
            // 1 sources

            {
            }
            var28_32 = results;
            return var28_32;
            {
                catch (IOException ex) {
                    try {
                        connection.close();
                    }
                    catch (IOException ex1) {
                        ex1.printStackTrace();
                    }
                    finally {
                        connection = null;
                    }
                    throw ex;
                }
                catch (Throwable var32_36) {
                    throw var32_36;
                }
            }
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int do_append_file(String group_name, String appender_filename, long file_size, UploadCallback callback) throws IOException, MyException {
        Connection connection = null;
        if (group_name == null || group_name.length() == 0 || appender_filename == null || appender_filename.length() == 0) {
            this.errno = (byte)22;
            return this.errno;
        }
        boolean bNewStorageServer = this.newUpdatableStorageConnection(group_name, appender_filename);
        try {
            connection = this.storageServer.getConnection();
            byte[] appenderFilenameBytes = appender_filename.getBytes(ClientGlobal.g_charset);
            long body_len = (long)(16 + appenderFilenameBytes.length) + file_size;
            byte[] header = ProtoCommon.packHeader((byte)24, body_len, (byte)0);
            byte[] wholePkg = new byte[(int)((long)header.length + body_len - file_size)];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            int offset = header.length;
            byte[] hexLenBytes = ProtoCommon.long2buff(appender_filename.length());
            System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
            offset += hexLenBytes.length;
            hexLenBytes = ProtoCommon.long2buff(file_size);
            System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
            OutputStream out = connection.getOutputStream();
            System.arraycopy(appenderFilenameBytes, 0, wholePkg, offset += hexLenBytes.length, appenderFilenameBytes.length);
            offset += appenderFilenameBytes.length;
            out.write(wholePkg);
            this.errno = (byte)callback.send(out);
            if (this.errno != 0) {
                byte by = this.errno;
                return by;
            }
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, 0L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                byte by = this.errno;
                return by;
            }
            int n = 0;
            return n;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(Connection connection, boolean bNewStorageServer) {
        try {
            if (connection != null) {
                connection.release();
            }
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        finally {
            if (bNewStorageServer) {
                this.storageServer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int do_modify_file(String group_name, String appender_filename, long file_offset, long modify_size, UploadCallback callback) throws IOException, MyException {
        Connection connection = null;
        if (group_name == null || group_name.length() == 0 || appender_filename == null || appender_filename.length() == 0) {
            this.errno = (byte)22;
            return this.errno;
        }
        boolean bNewStorageServer = this.newUpdatableStorageConnection(group_name, appender_filename);
        try {
            connection = this.storageServer.getConnection();
            byte[] appenderFilenameBytes = appender_filename.getBytes(ClientGlobal.g_charset);
            long body_len = (long)(24 + appenderFilenameBytes.length) + modify_size;
            byte[] header = ProtoCommon.packHeader((byte)34, body_len, (byte)0);
            byte[] wholePkg = new byte[(int)((long)header.length + body_len - modify_size)];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            int offset = header.length;
            byte[] hexLenBytes = ProtoCommon.long2buff(appender_filename.length());
            System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
            offset += hexLenBytes.length;
            hexLenBytes = ProtoCommon.long2buff(file_offset);
            System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
            offset += hexLenBytes.length;
            hexLenBytes = ProtoCommon.long2buff(modify_size);
            System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
            OutputStream out = connection.getOutputStream();
            System.arraycopy(appenderFilenameBytes, 0, wholePkg, offset += hexLenBytes.length, appenderFilenameBytes.length);
            offset += appenderFilenameBytes.length;
            out.write(wholePkg);
            this.errno = (byte)callback.send(out);
            if (this.errno != 0) {
                byte by = this.errno;
                return by;
            }
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, 0L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                byte by = this.errno;
                return by;
            }
            int n = 0;
            return n;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete_file(String group_name, String remote_filename) throws IOException, MyException {
        boolean bNewStorageServer = this.newUpdatableStorageConnection(group_name, remote_filename);
        Connection connection = this.storageServer.getConnection();
        try {
            this.send_package((byte)12, group_name, remote_filename, connection);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, 0L);
            this.errno = pkgInfo.errno;
            byte by = pkgInfo.errno;
            return by;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    public int truncate_file(String group_name, String appender_filename) throws IOException, MyException {
        long truncated_file_size = 0L;
        return this.truncate_file(group_name, appender_filename, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int truncate_file(String group_name, String appender_filename, long truncated_file_size) throws IOException, MyException {
        Connection connection = null;
        if (group_name == null || group_name.length() == 0 || appender_filename == null || appender_filename.length() == 0) {
            this.errno = (byte)22;
            return this.errno;
        }
        boolean bNewStorageServer = this.newUpdatableStorageConnection(group_name, appender_filename);
        try {
            connection = this.storageServer.getConnection();
            byte[] appenderFilenameBytes = appender_filename.getBytes(ClientGlobal.g_charset);
            int body_len = 16 + appenderFilenameBytes.length;
            byte[] header = ProtoCommon.packHeader((byte)36, body_len, (byte)0);
            byte[] wholePkg = new byte[header.length + body_len];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            int offset = header.length;
            byte[] hexLenBytes = ProtoCommon.long2buff(appender_filename.length());
            System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
            offset += hexLenBytes.length;
            hexLenBytes = ProtoCommon.long2buff(truncated_file_size);
            System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
            OutputStream out = connection.getOutputStream();
            System.arraycopy(appenderFilenameBytes, 0, wholePkg, offset += hexLenBytes.length, appenderFilenameBytes.length);
            offset += appenderFilenameBytes.length;
            out.write(wholePkg);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, 0L);
            this.errno = pkgInfo.errno;
            byte by = pkgInfo.errno;
            return by;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    public byte[] download_file(String group_name, String remote_filename) throws IOException, MyException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.download_file(group_name, remote_filename, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] download_file(String group_name, String remote_filename, long file_offset, long download_bytes) throws IOException, MyException {
        boolean bNewStorageServer = this.newReadableStorageConnection(group_name, remote_filename);
        Connection connection = this.storageServer.getConnection();
        try {
            this.send_download_package(group_name, remote_filename, file_offset, download_bytes, connection);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = pkgInfo.body;
            return byArray;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    public int download_file(String group_name, String remote_filename, String local_filename) throws IOException, MyException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.download_file(group_name, remote_filename, 0L, 0L, local_filename);
    }

    /*
     * Exception decompiling
     */
    public int download_file(String group_name, String remote_filename, long file_offset, long download_bytes, String local_filename) throws IOException, MyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int download_file(String group_name, String remote_filename, DownloadCallback callback) throws IOException, MyException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.download_file(group_name, remote_filename, 0L, 0L, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int download_file(String group_name, String remote_filename, long file_offset, long download_bytes, DownloadCallback callback) throws IOException, MyException {
        boolean bNewStorageServer = this.newReadableStorageConnection(group_name, remote_filename);
        Connection connection = this.storageServer.getConnection();
        try {
            int bytes;
            this.send_download_package(group_name, remote_filename, file_offset, download_bytes, connection);
            InputStream in = connection.getInputStream();
            ProtoCommon.RecvHeaderInfo header = ProtoCommon.recvHeader(in, (byte)100, -1L);
            this.errno = header.errno;
            if (header.errno != 0) {
                byte by = header.errno;
                return by;
            }
            byte[] buff = new byte[2048];
            for (long remainBytes = header.body_len; remainBytes > 0L; remainBytes -= (long)bytes) {
                bytes = in.read(buff, 0, remainBytes > (long)buff.length ? buff.length : (int)remainBytes);
                if (bytes < 0) {
                    throw new IOException("recv package size " + (header.body_len - remainBytes) + " != " + header.body_len);
                }
                int result = callback.recv(header.body_len, buff, bytes);
                if (result == 0) continue;
                this.errno = (byte)result;
                int n = result;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameValuePair[] get_metadata(String group_name, String remote_filename) throws IOException, MyException {
        boolean bNewStorageServer = this.newUpdatableStorageConnection(group_name, remote_filename);
        Connection connection = this.storageServer.getConnection();
        try {
            this.send_package((byte)15, group_name, remote_filename, connection);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                NameValuePair[] nameValuePairArray = null;
                return nameValuePairArray;
            }
            NameValuePair[] nameValuePairArray = ProtoCommon.split_metadata(new String(pkgInfo.body, ClientGlobal.g_charset));
            return nameValuePairArray;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_metadata(String group_name, String remote_filename, NameValuePair[] meta_list, byte op_flag) throws IOException, MyException {
        boolean bNewStorageServer = this.newUpdatableStorageConnection(group_name, remote_filename);
        Connection connection = this.storageServer.getConnection();
        try {
            byte[] meta_buff = meta_list == null ? new byte[]{} : ProtoCommon.pack_metadata(meta_list).getBytes(ClientGlobal.g_charset);
            byte[] filenameBytes = remote_filename.getBytes(ClientGlobal.g_charset);
            byte[] sizeBytes = new byte[16];
            Arrays.fill(sizeBytes, (byte)0);
            byte[] bs = ProtoCommon.long2buff(filenameBytes.length);
            System.arraycopy(bs, 0, sizeBytes, 0, bs.length);
            bs = ProtoCommon.long2buff(meta_buff.length);
            System.arraycopy(bs, 0, sizeBytes, 8, bs.length);
            byte[] groupBytes = new byte[16];
            bs = group_name.getBytes(ClientGlobal.g_charset);
            Arrays.fill(groupBytes, (byte)0);
            int groupLen = bs.length <= groupBytes.length ? bs.length : groupBytes.length;
            System.arraycopy(bs, 0, groupBytes, 0, groupLen);
            byte[] header = ProtoCommon.packHeader((byte)13, 17 + groupBytes.length + filenameBytes.length + meta_buff.length, (byte)0);
            OutputStream out = connection.getOutputStream();
            byte[] wholePkg = new byte[header.length + sizeBytes.length + 1 + groupBytes.length + filenameBytes.length];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(sizeBytes, 0, wholePkg, header.length, sizeBytes.length);
            wholePkg[header.length + sizeBytes.length] = op_flag;
            System.arraycopy(groupBytes, 0, wholePkg, header.length + sizeBytes.length + 1, groupBytes.length);
            System.arraycopy(filenameBytes, 0, wholePkg, header.length + sizeBytes.length + 1 + groupBytes.length, filenameBytes.length);
            out.write(wholePkg);
            if (meta_buff.length > 0) {
                out.write(meta_buff);
            }
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, 0L);
            this.errno = pkgInfo.errno;
            byte by = pkgInfo.errno;
            return by;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    public FileInfo get_file_info(String group_name, String remote_filename) throws IOException, MyException {
        if (remote_filename.length() < 44) {
            this.errno = (byte)22;
            return null;
        }
        byte[] buff = base64.decodeAuto(remote_filename.substring(10, 37));
        long file_size = ProtoCommon.buff2long(buff, 8);
        short file_type = (file_size & 0x400000000000000L) != 0L ? (short)2 : ((long)remote_filename.length() > 60L || (long)remote_filename.length() > 44L && (file_size & 0x800000000000000L) == 0L ? (short)4 : 1);
        if (file_type == 4 || file_type == 2) {
            FileInfo fi = this.query_file_info(group_name, remote_filename);
            if (fi == null) {
                return null;
            }
            fi.setFileType(file_type);
            return fi;
        }
        int create_timestamp = ProtoCommon.buff2int(buff, 4);
        if (file_size >> 63 != 0L) {
            file_size &= 0xFFFFFFFFL;
        }
        int crc32 = ProtoCommon.buff2int(buff, 16);
        return new FileInfo(false, file_type, file_size, create_timestamp, crc32, ProtoCommon.getIpAddress(buff, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo query_file_info(String group_name, String remote_filename) throws IOException, MyException {
        boolean bNewStorageServer = this.newUpdatableStorageConnection(group_name, remote_filename);
        Connection connection = this.storageServer.getConnection();
        try {
            byte[] filenameBytes = remote_filename.getBytes(ClientGlobal.g_charset);
            byte[] groupBytes = new byte[16];
            byte[] bs = group_name.getBytes(ClientGlobal.g_charset);
            Arrays.fill(groupBytes, (byte)0);
            int groupLen = bs.length <= groupBytes.length ? bs.length : groupBytes.length;
            System.arraycopy(bs, 0, groupBytes, 0, groupLen);
            byte[] header = ProtoCommon.packHeader((byte)22, groupBytes.length + filenameBytes.length, (byte)0);
            OutputStream out = connection.getOutputStream();
            byte[] wholePkg = new byte[header.length + groupBytes.length + filenameBytes.length];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(groupBytes, 0, wholePkg, header.length, groupBytes.length);
            System.arraycopy(filenameBytes, 0, wholePkg, header.length + groupBytes.length, filenameBytes.length);
            out.write(wholePkg);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(connection.getInputStream(), (byte)100, 70L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                FileInfo fileInfo = null;
                return fileInfo;
            }
            long file_size = ProtoCommon.buff2long(pkgInfo.body, 0);
            int create_timestamp = (int)ProtoCommon.buff2long(pkgInfo.body, 8);
            int crc32 = (int)ProtoCommon.buff2long(pkgInfo.body, 16);
            String source_ip_addr = new String(pkgInfo.body, 24, 46).trim();
            FileInfo fileInfo = new FileInfo(true, 1, file_size, create_timestamp, crc32, source_ip_addr);
            return fileInfo;
        }
        catch (IOException ex) {
            try {
                connection.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            finally {
                connection = null;
            }
            throw ex;
        }
        finally {
            this.releaseConnection(connection, bNewStorageServer);
        }
    }

    protected boolean newWritableStorageConnection(String group_name) throws IOException, MyException {
        if (this.storageServer != null) {
            return false;
        }
        TrackerClient tracker = new TrackerClient();
        this.storageServer = tracker.getStoreStorage(this.trackerServer, group_name);
        if (this.storageServer == null) {
            throw new MyException("getStoreStorage fail, errno code: " + tracker.getErrorCode());
        }
        return true;
    }

    protected boolean newReadableStorageConnection(String group_name, String remote_filename) throws IOException, MyException {
        if (this.storageServer != null) {
            return false;
        }
        TrackerClient tracker = new TrackerClient();
        this.storageServer = tracker.getFetchStorage(this.trackerServer, group_name, remote_filename);
        if (this.storageServer == null) {
            throw new MyException("getStoreStorage fail, errno code: " + tracker.getErrorCode());
        }
        return true;
    }

    protected boolean newUpdatableStorageConnection(String group_name, String remote_filename) throws IOException, MyException {
        if (this.storageServer != null) {
            return false;
        }
        TrackerClient tracker = new TrackerClient();
        this.storageServer = tracker.getUpdateStorage(this.trackerServer, group_name, remote_filename);
        if (this.storageServer == null) {
            throw new MyException("getStoreStorage fail, errno code: " + tracker.getErrorCode());
        }
        return true;
    }

    protected void send_package(byte cmd, String group_name, String remote_filename, Connection connection) throws IOException {
        byte[] groupBytes = new byte[16];
        byte[] bs = group_name.getBytes(ClientGlobal.g_charset);
        byte[] filenameBytes = remote_filename.getBytes(ClientGlobal.g_charset);
        Arrays.fill(groupBytes, (byte)0);
        int groupLen = bs.length <= groupBytes.length ? bs.length : groupBytes.length;
        System.arraycopy(bs, 0, groupBytes, 0, groupLen);
        byte[] header = ProtoCommon.packHeader(cmd, groupBytes.length + filenameBytes.length, (byte)0);
        byte[] wholePkg = new byte[header.length + groupBytes.length + filenameBytes.length];
        System.arraycopy(header, 0, wholePkg, 0, header.length);
        System.arraycopy(groupBytes, 0, wholePkg, header.length, groupBytes.length);
        System.arraycopy(filenameBytes, 0, wholePkg, header.length + groupBytes.length, filenameBytes.length);
        connection.getOutputStream().write(wholePkg);
    }

    protected void send_download_package(String group_name, String remote_filename, long file_offset, long download_bytes, Connection connection) throws IOException {
        byte[] bsOffset = ProtoCommon.long2buff(file_offset);
        byte[] bsDownBytes = ProtoCommon.long2buff(download_bytes);
        byte[] groupBytes = new byte[16];
        byte[] bs = group_name.getBytes(ClientGlobal.g_charset);
        byte[] filenameBytes = remote_filename.getBytes(ClientGlobal.g_charset);
        Arrays.fill(groupBytes, (byte)0);
        int groupLen = bs.length <= groupBytes.length ? bs.length : groupBytes.length;
        System.arraycopy(bs, 0, groupBytes, 0, groupLen);
        byte[] header = ProtoCommon.packHeader((byte)14, bsOffset.length + bsDownBytes.length + groupBytes.length + filenameBytes.length, (byte)0);
        byte[] wholePkg = new byte[header.length + bsOffset.length + bsDownBytes.length + groupBytes.length + filenameBytes.length];
        System.arraycopy(header, 0, wholePkg, 0, header.length);
        System.arraycopy(bsOffset, 0, wholePkg, header.length, bsOffset.length);
        System.arraycopy(bsDownBytes, 0, wholePkg, header.length + bsOffset.length, bsDownBytes.length);
        System.arraycopy(groupBytes, 0, wholePkg, header.length + bsOffset.length + bsDownBytes.length, groupBytes.length);
        System.arraycopy(filenameBytes, 0, wholePkg, header.length + bsOffset.length + bsDownBytes.length + groupBytes.length, filenameBytes.length);
        connection.getOutputStream().write(wholePkg);
    }

    public boolean isConnected() {
        return this.trackerServer != null;
    }

    public boolean isAvaliable() {
        return this.trackerServer != null;
    }

    public void close() throws IOException {
        this.trackerServer = null;
    }

    public TrackerServer getTrackerServer() {
        return this.trackerServer;
    }

    public void setTrackerServer(TrackerServer trackerServer) {
        this.trackerServer = trackerServer;
    }

    public StorageServer getStorageServer() {
        return this.storageServer;
    }

    public void setStorageServer(StorageServer storageServer) {
        this.storageServer = storageServer;
    }

    public static class UploadBuff
    implements UploadCallback {
        private byte[] fileBuff;
        private int offset;
        private int length;

        public UploadBuff(byte[] fileBuff, int offset, int length) {
            this.fileBuff = fileBuff;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int send(OutputStream out) throws IOException {
            out.write(this.fileBuff, this.offset, this.length);
            return 0;
        }
    }
}

