/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AlpacaProperties {
    private static Properties propertyFile;
    private static final String KEY_ID_KEY = "key_id";
    private static final String SECRET_KEY = "secret";
    private static final String BASE_ACCOUNT_URL_KEY = "base_url";
    private static final String BASE_DATA_URL_KEY = "base_data_url";
    private static final String USER_AGENT_KEY = "user_agent";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36";
    private static final String DEFAULT_ACCOUNT_URL = "https://paper-api.alpaca.markets";
    private static final String DEFAULT_DATA_URL = "https://data.alpaca.markets";
    public static final String INVALID_VALUE = "INVALID";
    public static final String KEY_ID_VALUE;
    public static final String SECRET_VALUE;
    public static final String BASE_ACCOUNT_URL_VALUE;
    public static String BASE_DATA_URL_VALUE;
    public static final String USER_AGENT_VALUE;

    public static String getProperty(String key, String defaultValue) {
        return propertyFile.getProperty(key, defaultValue);
    }

    static {
        InputStream is = AlpacaProperties.class.getResourceAsStream("/alpaca.properties");
        propertyFile = new Properties();
        try {
            propertyFile.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        KEY_ID_VALUE = AlpacaProperties.getProperty(KEY_ID_KEY, INVALID_VALUE);
        SECRET_VALUE = AlpacaProperties.getProperty(SECRET_KEY, INVALID_VALUE);
        BASE_ACCOUNT_URL_VALUE = AlpacaProperties.getProperty(BASE_ACCOUNT_URL_KEY, DEFAULT_ACCOUNT_URL);
        BASE_DATA_URL_VALUE = AlpacaProperties.getProperty(BASE_DATA_URL_KEY, DEFAULT_DATA_URL);
        USER_AGENT_VALUE = AlpacaProperties.getProperty(USER_AGENT_KEY, DEFAULT_USER_AGENT);
    }
}

