/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.rest.bars;

import io.github.mainstringargs.alpaca.Utilities;
import io.github.mainstringargs.alpaca.enums.BarsTimeFrame;
import io.github.mainstringargs.alpaca.rest.bars.BarsRequestBuilder;
import java.time.LocalDateTime;

public class GetBarsRequestBuilder
extends BarsRequestBuilder {
    public GetBarsRequestBuilder(String baseUrl) {
        super(baseUrl);
    }

    public GetBarsRequestBuilder timeframe(BarsTimeFrame timeframe) {
        if (timeframe != null) {
            super.appendEndpoint(timeframe.getAPIName());
        }
        return this;
    }

    public GetBarsRequestBuilder start(LocalDateTime start) {
        if (start != null) {
            super.appendURLParameter("start", Utilities.toDateTimeString(start));
        }
        return this;
    }

    public GetBarsRequestBuilder end(LocalDateTime end) {
        if (end != null) {
            super.appendURLParameter("end", Utilities.toDateTimeString(end));
        }
        return this;
    }

    public GetBarsRequestBuilder after(LocalDateTime after) {
        if (after != null) {
            super.appendURLParameter("after", Utilities.toDateTimeString(after));
        }
        return this;
    }

    public GetBarsRequestBuilder until(LocalDateTime until) {
        if (until != null) {
            super.appendURLParameter("until", Utilities.toDateTimeString(until));
        }
        return this;
    }

    public GetBarsRequestBuilder limit(Integer limit) {
        if (limit != null) {
            super.appendURLParameter("limit", limit.toString());
        }
        return this;
    }

    public GetBarsRequestBuilder symbols(String ... symbols) {
        if (symbols != null) {
            super.appendURLParameter("symbols", String.join((CharSequence)",", symbols));
        }
        return this;
    }
}

