/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.abstracts.rest;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import io.github.mainstringargs.abstracts.rest.AbstractRequestBuilder;
import io.github.mainstringargs.util.gson.GsonUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRequest {
    private static final Logger LOGGER = LogManager.getLogger(AbstractRequest.class);
    protected final Map<String, String> headers = new HashMap<String, String>();

    public HttpResponse<InputStream> invokeGet(AbstractRequestBuilder abstractRequestBuilder) {
        try {
            String url = abstractRequestBuilder.getURL();
            LOGGER.debug("GET URL " + url);
            GetRequest request = Unirest.get((String)url);
            if (!this.headers.isEmpty()) {
                request.headers(this.headers);
                LOGGER.debug("GET Headers: " + this.headers);
            }
            return request.asBinary();
        }
        catch (UnirestException e) {
            LOGGER.error("UnirestException", (Throwable)e);
            return null;
        }
    }

    public HttpResponse<InputStream> invokeHead(AbstractRequestBuilder abstractRequestBuilder) {
        try {
            String url = abstractRequestBuilder.getURL();
            LOGGER.debug("HEAD URL " + url);
            GetRequest request = Unirest.head((String)url);
            if (!this.headers.isEmpty()) {
                request.headers(this.headers);
                LOGGER.debug("HEAD Headers: " + this.headers);
            }
            return request.asBinary();
        }
        catch (UnirestException e) {
            LOGGER.error("UnirestException", (Throwable)e);
            return null;
        }
    }

    public HttpResponse<InputStream> invokePost(AbstractRequestBuilder abstractRequestBuilder) {
        try {
            String body;
            String url = abstractRequestBuilder.getURL();
            LOGGER.debug("POST URL: " + url);
            HttpRequestWithBody request = Unirest.post((String)url);
            if (!this.headers.isEmpty()) {
                request.headers(this.headers);
                LOGGER.debug("POST Headers: " + this.headers);
            }
            if ((body = abstractRequestBuilder.getBody()) != null) {
                request.body(body);
                LOGGER.debug("POST Body: " + body);
            }
            return request.asBinary();
        }
        catch (UnirestException e) {
            LOGGER.error("UnirestException", (Throwable)e);
            return null;
        }
    }

    public HttpResponse<InputStream> invokePatch(AbstractRequestBuilder abstractRequestBuilder) {
        try {
            String body;
            String url = abstractRequestBuilder.getURL();
            LOGGER.debug("PATCH URL " + url);
            HttpRequestWithBody request = Unirest.patch((String)url);
            if (!this.headers.isEmpty()) {
                request.headers(this.headers);
                LOGGER.debug("PATCH Headers: " + this.headers);
            }
            if ((body = abstractRequestBuilder.getBody()) != null) {
                request.body(body);
                LOGGER.debug("PATCH Body: " + body);
            }
            return request.asBinary();
        }
        catch (UnirestException e) {
            LOGGER.error("UnirestException", (Throwable)e);
            return null;
        }
    }

    public HttpResponse<InputStream> invokePut(AbstractRequestBuilder abstractRequestBuilder) {
        try {
            String body;
            String url = abstractRequestBuilder.getURL();
            LOGGER.debug("PUT URL " + url);
            HttpRequestWithBody request = Unirest.put((String)url);
            if (!this.headers.isEmpty()) {
                request.headers(this.headers);
                LOGGER.debug("PUT Headers: " + this.headers);
            }
            if ((body = abstractRequestBuilder.getBody()) != null) {
                request.body(body);
                LOGGER.debug("PUT Body: " + body);
            }
            return request.asBinary();
        }
        catch (UnirestException e) {
            LOGGER.error("UnirestException", (Throwable)e);
            return null;
        }
    }

    public HttpResponse<InputStream> invokeDelete(AbstractRequestBuilder abstractRequestBuilder) {
        try {
            String body;
            String url = abstractRequestBuilder.getURL();
            LOGGER.debug("DELETE URL " + url);
            HttpRequestWithBody request = Unirest.delete((String)url);
            if (!this.headers.isEmpty()) {
                request.headers(this.headers);
                LOGGER.debug("DELETE Headers: " + this.headers);
            }
            if ((body = abstractRequestBuilder.getBody()) != null) {
                request.body(body);
                LOGGER.debug("DELETE Body: " + body);
            }
            return request.asBinary();
        }
        catch (UnirestException e) {
            LOGGER.error("UnirestException", (Throwable)e);
            return null;
        }
    }

    public HttpResponse<InputStream> invokeOptions(AbstractRequestBuilder abstractRequestBuilder) {
        try {
            String body;
            String url = abstractRequestBuilder.getURL();
            LOGGER.debug("OPTIONS URL " + url);
            HttpRequestWithBody request = Unirest.options((String)url);
            if (!this.headers.isEmpty()) {
                request.headers(this.headers);
                LOGGER.debug("OPTIONS Headers: " + this.headers);
            }
            if ((body = abstractRequestBuilder.getBody()) != null) {
                request.body(body);
                LOGGER.debug("OPTIONS Body: " + body);
            }
            return request.asBinary();
        }
        catch (UnirestException e) {
            LOGGER.error("UnirestException", (Throwable)e);
            return null;
        }
    }

    public <T> T getResponseObject(HttpResponse<InputStream> httpResponse, Type type) {
        Object responseObjectFromJson = null;
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(httpResponse.getRawBody()));){
            responseObjectFromJson = GsonUtil.GSON.fromJson(jsonReader, type);
        }
        catch (Exception e) {
            LOGGER.error("Exception", (Throwable)e);
        }
        return (T)responseObjectFromJson;
    }

    public JsonElement getResponseJSON(HttpResponse<InputStream> httpResponse) {
        JsonElement responseJsonElement = null;
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(httpResponse.getRawBody()));){
            responseJsonElement = GsonUtil.JSON_PARSER.parse(jsonReader);
        }
        catch (Exception e) {
            LOGGER.error("Exception", (Throwable)e);
        }
        return responseJsonElement;
    }
}

