/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock.provider;

import io.github.md2java.lock.model.LockInfo;
import io.github.md2java.lock.provider.LockProvider;
import io.github.md2java.lock.util.MemoryUtil;
import io.github.md2java.lock.util.NodeUtil;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdateLockScheduler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UpdateLockScheduler.class);
    @Autowired
    private LockProvider lockProvider;
    private Set<String> locknames;

    @Override
    public void run() {
        this.getLocknames().stream().forEach(lockname -> {
            LockInfo lockInfo = MemoryUtil.getLockInfo(lockname);
            if (BooleanUtils.isFalse((Boolean)StringUtils.equalsIgnoreCase((CharSequence)lockInfo.getActiveNode(), (CharSequence)NodeUtil.hostId()))) {
                log.debug("skipped {} current node:{} is not activenode:{} ", new Object[]{lockInfo.getLockname(), NodeUtil.hostId(), lockInfo.getActiveNode()});
            }
            log.debug("updateLock started..");
            this.lockProvider.updateLock((String)lockname);
            log.debug("updateLock end..");
        });
    }

    public Set<String> getLocknames() {
        return this.locknames;
    }

    public void setLocknames(Set<String> locknames) {
        this.locknames = locknames;
    }
}

