/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class ImageInfo {
    public static final String FormatPNG = "png";
    public static final String FormatJPG = "jpg";
    private BufferedImage _Image = null;
    private int _X = 0;
    private int _Y = 0;
    private int _symbolCenterX = 0;
    private int _symbolCenterY = 0;
    Rectangle2D _symbolBounds = null;

    protected ImageInfo() {
    }

    public ImageInfo(BufferedImage image, int x, int y) {
        this._Image = image;
        this._X = x;
        this._Y = y;
        this._symbolCenterX = image.getWidth() / 2;
        this._symbolCenterY = image.getHeight() / 2;
    }

    public ImageInfo(BufferedImage image, int x, int y, int symbolCenterX, int symbolCenterY) {
        this._Image = image;
        this._X = x;
        this._Y = y;
        this._symbolCenterX = symbolCenterX;
        this._symbolCenterY = symbolCenterY;
    }

    public ImageInfo(BufferedImage image, int x, int y, int symbolCenterX, int symbolCenterY, Rectangle2D symbolBounds) {
        this._Image = image;
        this._X = x;
        this._Y = y;
        this._symbolCenterX = symbolCenterX;
        this._symbolCenterY = symbolCenterY;
        this._symbolBounds = symbolBounds;
    }

    public BufferedImage getImage() {
        return this._Image;
    }

    public int getX() {
        return this._X;
    }

    public int getY() {
        return this._Y;
    }

    public Point getPoint() {
        return new Point(this._X, this._Y);
    }

    public int getSymbolCenterX() {
        return this._symbolCenterX;
    }

    public int getSymbolCenterY() {
        return this._symbolCenterY;
    }

    public Point getSymbolCenterPoint() {
        return new Point(this._symbolCenterX, this._symbolCenterY);
    }

    public Rectangle2D getSymbolBounds() {
        return this._symbolBounds;
    }

    public Boolean SaveImageToFile(String filePath, String imageFormat) {
        try {
            File outFile = new File(filePath);
            return ImageIO.write((RenderedImage)this._Image, imageFormat, outFile);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("ImageInfo", "SaveImageToFile", exc);
            return false;
        }
    }

    public Boolean SaveImageToPNG(ImageOutputStream ios) {
        try {
            BufferedImage image = this._Image;
            Iterator<ImageWriter> itr = ImageIO.getImageWritersBySuffix(FormatPNG);
            String metaDataFormatName = "";
            if (itr.hasNext()) {
                ImageWriter iw = itr.next();
                IIOMetadata meta = iw.getDefaultImageMetadata(new ImageTypeSpecifier(image), null);
                metaDataFormatName = meta.getMetadataFormatNames()[0];
                StringBuilder XML = new StringBuilder("");
                XML.append("<" + metaDataFormatName + ">");
                XML.append("<tEXt>");
                XML.append("<tEXtEntry keyword=\"centerPoint\" value=\"x=" + String.valueOf(this._symbolCenterX) + ",y=" + String.valueOf(this._symbolCenterY) + "\"/>");
                XML.append("<tEXtEntry keyword=\"bounds\" value=\"x=" + String.valueOf(this._symbolBounds.getX()) + ",y=" + String.valueOf(this._symbolBounds.getY()) + ",width=" + String.valueOf(this._symbolBounds.getWidth()) + ",height=" + String.valueOf(this._symbolBounds.getHeight()) + "\"/>");
                XML.append("<tEXtEntry keyword=\"imageExtent\" value=\"width=" + String.valueOf(this._Image.getWidth()) + ",height=" + String.valueOf(this._Image.getHeight()) + "\"/>");
                XML.append("</tEXt>");
                XML.append("</" + metaDataFormatName + ">");
                DOMResult domresult = new DOMResult();
                TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(XML.toString())), domresult);
                Node document = domresult.getNode();
                meta.mergeTree(metaDataFormatName, document.getFirstChild());
                IIOImage iioImage = new IIOImage(image, null, null);
                iioImage.setMetadata(meta);
                iw.setOutput(ios);
                iw.write(null, iioImage, null);
                ios.close();
                iw.dispose();
                iw = null;
                itr = null;
                iioImage = null;
                return true;
            }
            ErrorLogger.LogMessage("ImageInfo", "SaveImageToPNG", "no PNG imageWriter available");
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("ImageInfo", "SaveImageToFile", exc);
            return false;
        }
    }

    public static BufferedImage CenterImageOnPoint(BufferedImage image, Point2D point) {
        BufferedImage bi = null;
        int x = 0;
        int y = 0;
        int height = 0;
        int width = 0;
        height = image.getHeight();
        width = image.getWidth();
        try {
            if (point.getY() > (double)height - point.getY()) {
                height = (int)(point.getY() * 2.0);
                y = 0;
            } else {
                height = (int)(((double)height - point.getY()) * 2.0);
                y = (int)((double)(height / 2) - point.getY());
            }
            if (point.getX() > (double)width - point.getX()) {
                width = (int)(point.getX() * 2.0);
                x = 0;
            } else {
                width = (int)(((double)width - point.getX()) * 2.0);
                x = (int)((double)(width / 2) - point.getX());
            }
            bi = new BufferedImage(width, height, 2);
            Graphics2D g2d = bi.createGraphics();
            g2d.drawImage((Image)image, x, y, null);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("ImageInfo", "CenterImageOnPoint", exc);
        }
        return bi;
    }

    public static Boolean CanWriteImageFormat(String format) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(format);
        return iter.hasNext();
    }

    public static BufferedImage getScaledInstance(BufferedImage srcImage, int targetWidth, int targetHeight, Object hint, boolean higherQuality, boolean keepProportion) {
        int h;
        int w;
        int type = srcImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = srcImage;
        double ratio = 0.0;
        double SrcW = srcImage.getWidth();
        double SrcH = srcImage.getHeight();
        double tW = targetWidth;
        double tH = targetHeight;
        if (keepProportion) {
            ratio = Math.min(tH / SrcH, tW / SrcW);
            targetWidth = (int)(SrcW * ratio);
            targetHeight = (int)(SrcH * ratio);
        }
        if (higherQuality) {
            w = srcImage.getWidth();
            h = srcImage.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }
}

