package com.monmonkeygroup.openapi.client;

import com.monmonkeygroup.openapi.OpenApiException;
import com.monmonkeygroup.openapi.protocol.Packet;

interface ISocketServiceListener {
     void onConnected();
    void onMessage(Packet packet);
    void onClose(String reason);
}

public interface IClientConn {
    void init() throws OpenApiException;
    boolean isOpen();
    void sendPacket(Packet packet);
    boolean reconnectSocket() throws Exception ;
    void close(String reason);

    void addListener(ISocketServiceListener listener);
}
