/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils.model;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum TypeCategory {
    SIMPLE(null, new String[0]),
    MAP(null, new String[0]),
    COLLECTION(null, new String[0]),
    LIST(COLLECTION, new String[0]),
    SET(COLLECTION, new String[0]),
    ARRAY(null, new String[0]),
    COMPARABLE(SIMPLE, new String[0]),
    BOOLEAN(COMPARABLE, Boolean.class.getName()),
    DATE(COMPARABLE, java.sql.Date.class.getName(), LocalDate.class.getName()),
    DATETIME(COMPARABLE, Calendar.class.getName(), Date.class.getName(), Timestamp.class.getName(), Instant.class.getName(), LocalDateTime.class.getName(), OffsetDateTime.class.getName(), ZonedDateTime.class.getName()),
    ENUM(COMPARABLE, new String[0]),
    CUSTOM(null, new String[0]),
    ENTITY(null, new String[0]),
    NUMERIC(COMPARABLE, new String[0]),
    STRING(COMPARABLE, String.class.getName()),
    TIME(COMPARABLE, Time.class.getName(), LocalTime.class.getName(), OffsetTime.class.getName());

    private final TypeCategory superType;
    private final Set<String> types;

    private TypeCategory(TypeCategory superType, String ... types) {
        this.superType = superType;
        this.types = new HashSet<String>(types.length);
        for (String type : types) {
            this.types.add(type);
        }
    }

    public TypeCategory getSuperType() {
        return this.superType;
    }

    public boolean supports(Class<?> cl) {
        return this.supports(cl.getName());
    }

    public boolean supports(String className) {
        return this.types.contains(className);
    }

    public boolean isSubCategoryOf(TypeCategory ancestor) {
        if (this == ancestor) {
            return true;
        }
        if (this.superType == null) {
            return false;
        }
        return this.superType == ancestor || this.superType.isSubCategoryOf(ancestor);
    }

    public static TypeCategory get(String className) {
        for (TypeCategory category : TypeCategory.values()) {
            if (!category.supports(className)) continue;
            return category;
        }
        return SIMPLE;
    }
}

