/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.sql.codegen.ExtendedNamingStrategy;
import com.querydsl.sql.codegen.NamingStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtendedNamingStrategyTest {
    private NamingStrategy namingStrategy = new ExtendedNamingStrategy();
    private EntityType entityModel;

    @Before
    public void setUp() {
        this.entityModel = new EntityType((Type)Types.OBJECT);
        this.entityModel.getData().put("table", "OBJECT");
    }

    @Test
    public void getClassName() {
        Assert.assertEquals((Object)"UserData", (Object)this.namingStrategy.getClassName("user_data"));
        Assert.assertEquals((Object)"U", (Object)this.namingStrategy.getClassName("u"));
        Assert.assertEquals((Object)"Us", (Object)this.namingStrategy.getClassName("us"));
        Assert.assertEquals((Object)"U_", (Object)this.namingStrategy.getClassName("u_"));
        Assert.assertEquals((Object)"Us_", (Object)this.namingStrategy.getClassName("us_"));
    }

    @Test
    public void getPropertyName() {
        Assert.assertEquals((Object)"whileCol", (Object)this.namingStrategy.getPropertyName("while", this.entityModel));
        Assert.assertEquals((Object)"name", (Object)this.namingStrategy.getPropertyName("name", this.entityModel));
        Assert.assertEquals((Object)"userId", (Object)this.namingStrategy.getPropertyName("user_id", this.entityModel));
        Assert.assertEquals((Object)"accountEventId", (Object)this.namingStrategy.getPropertyName("accountEvent_id", this.entityModel));
        Assert.assertEquals((Object)"_123abc", (Object)this.namingStrategy.getPropertyName("123abc", this.entityModel));
        Assert.assertEquals((Object)"_123Abc", (Object)this.namingStrategy.getPropertyName("123 abc", this.entityModel));
    }

    @Test
    public void getPropertyName_for_column_with_spaces() {
        Assert.assertEquals((Object)"userId", (Object)this.namingStrategy.getPropertyName("user id", this.entityModel));
    }

    @Test
    public void getPropertyNameForInverseForeignKey() {
        Assert.assertEquals((Object)"_superiorFk", (Object)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_superior", this.entityModel));
        Assert.assertEquals((Object)"rows", (Object)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_order_rows", this.entityModel));
        Assert.assertEquals((Object)"events", (Object)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_category_events", this.entityModel));
    }

    @Test
    public void getPropertyNameForForeignKey() {
        Assert.assertEquals((Object)"superiorFk", (Object)this.namingStrategy.getPropertyNameForForeignKey("fk_superior", this.entityModel));
        Assert.assertEquals((Object)"superiorFk", (Object)this.namingStrategy.getPropertyNameForForeignKey("FK_SUPERIOR", this.entityModel));
        Assert.assertEquals((Object)"order", (Object)this.namingStrategy.getPropertyNameForForeignKey("fk_order_rows", this.entityModel));
        Assert.assertEquals((Object)"category", (Object)this.namingStrategy.getPropertyNameForForeignKey("fk_category_events", this.entityModel));
    }

    @Test
    public void getPropertyNameForPrimaryKey() {
        Assert.assertEquals((Object)"superiorPk", (Object)this.namingStrategy.getPropertyNameForPrimaryKey("pk_superior", this.entityModel));
        Assert.assertEquals((Object)"superiorPk", (Object)this.namingStrategy.getPropertyNameForPrimaryKey("PK_SUPERIOR", this.entityModel));
    }

    @Test
    public void getDefaultVariableName() {
        Assert.assertEquals((Object)"object", (Object)this.namingStrategy.getDefaultVariableName(this.entityModel));
    }
}

