/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen.support;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.codegen.support.RenameMapping;
import org.junit.Assert;
import org.junit.Test;

public class RenameMappingTest {
    private RenameMapping mapping = new RenameMapping();
    private Configuration configuration = new Configuration(SQLTemplates.DEFAULT);

    @Test
    public void schemaToSchema() {
        this.mapping.setFromSchema("ABC");
        this.mapping.setToSchema("DEF");
        this.mapping.apply(this.configuration);
        Assert.assertEquals((Object)new SchemaAndTable("DEF", "TABLE"), (Object)this.configuration.getOverride(new SchemaAndTable("ABC", "TABLE")));
        Assert.assertEquals((Object)new SchemaAndTable("ABCD", "TABLE"), (Object)this.configuration.getOverride(new SchemaAndTable("ABCD", "TABLE")));
    }

    @Test
    public void tableToTable() {
        this.mapping.setFromTable("TABLE1");
        this.mapping.setToTable("TABLE2");
        this.mapping.apply(this.configuration);
        Assert.assertEquals((Object)new SchemaAndTable("DEF", "TABLE2"), (Object)this.configuration.getOverride(new SchemaAndTable("DEF", "TABLE1")));
        Assert.assertEquals((Object)new SchemaAndTable("DEF", "TABLE3"), (Object)this.configuration.getOverride(new SchemaAndTable("DEF", "TABLE3")));
    }

    @Test
    public void schemaTableToTable() {
        this.mapping.setFromSchema("ABC");
        this.mapping.setFromTable("TABLE1");
        this.mapping.setToTable("TABLE2");
        this.mapping.apply(this.configuration);
        Assert.assertEquals((Object)new SchemaAndTable("ABC", "TABLE2"), (Object)this.configuration.getOverride(new SchemaAndTable("ABC", "TABLE1")));
        Assert.assertEquals((Object)new SchemaAndTable("DEF", "TABLE1"), (Object)this.configuration.getOverride(new SchemaAndTable("DEF", "TABLE1")));
    }

    @Test
    public void schemaTableToSchemaTable() {
        this.mapping.setFromSchema("ABC");
        this.mapping.setFromTable("TABLE1");
        this.mapping.setToSchema("ABC");
        this.mapping.setToTable("TABLE2");
        this.mapping.apply(this.configuration);
        Assert.assertEquals((Object)new SchemaAndTable("ABC", "TABLE2"), (Object)this.configuration.getOverride(new SchemaAndTable("ABC", "TABLE1")));
        Assert.assertEquals((Object)new SchemaAndTable("DEF", "TABLE1"), (Object)this.configuration.getOverride(new SchemaAndTable("DEF", "TABLE1")));
    }

    @Test
    public void schemaTableColumnToColumn() {
        this.mapping.setFromSchema("ABC");
        this.mapping.setFromTable("TABLE1");
        this.mapping.setFromColumn("COLUMN1");
        this.mapping.setToColumn("COLUMN2");
        this.mapping.apply(this.configuration);
        Assert.assertEquals((Object)"COLUMN2", (Object)this.configuration.getColumnOverride(new SchemaAndTable("ABC", "TABLE1"), "COLUMN1"));
        Assert.assertEquals((Object)"COLUMN1", (Object)this.configuration.getColumnOverride(new SchemaAndTable("DEF", "TABLE1"), "COLUMN1"));
    }

    @Test
    public void tableColumnToColumn() {
        this.mapping.setFromTable("TABLE1");
        this.mapping.setFromColumn("COLUMN1");
        this.mapping.setToColumn("COLUMN2");
        this.mapping.apply(this.configuration);
        Assert.assertEquals((Object)"COLUMN2", (Object)this.configuration.getColumnOverride(new SchemaAndTable("ABC", "TABLE1"), "COLUMN1"));
        Assert.assertEquals((Object)"COLUMN1", (Object)this.configuration.getColumnOverride(new SchemaAndTable("ABC", "TABLE2"), "COLUMN1"));
    }
}

