/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen.support;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.codegen.support.Mapping;
import com.querydsl.sql.types.Type;

public class TypeMapping
implements Mapping {
    private String table;
    private String column;
    private String type;

    public TypeMapping() {
    }

    public TypeMapping(String table, String column, String type) {
        this();
        this.table = table;
        this.column = column;
        this.type = type;
    }

    @Override
    public void apply(Configuration configuration) {
        try {
            Class<?> typeClass = Class.forName(this.type);
            if (Type.class.isAssignableFrom(typeClass)) {
                configuration.register(this.table, this.column, (Type)typeClass.newInstance());
            } else {
                configuration.register(this.table, this.column, typeClass);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

