/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.sql.codegen.ExtendedNamingStrategy;
import com.querydsl.sql.codegen.NamingStrategy;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ExtendedNamingStrategyTest {
    private NamingStrategy namingStrategy = new ExtendedNamingStrategy();
    private EntityType entityModel;

    @Before
    public void setUp() {
        this.entityModel = new EntityType((Type)Types.OBJECT);
        this.entityModel.getData().put("table", "OBJECT");
    }

    @Test
    public void getClassName() {
        Assertions.assertThat((String)this.namingStrategy.getClassName("user_data")).isEqualTo("UserData");
        Assertions.assertThat((String)this.namingStrategy.getClassName("u")).isEqualTo("U");
        Assertions.assertThat((String)this.namingStrategy.getClassName("us")).isEqualTo("Us");
        Assertions.assertThat((String)this.namingStrategy.getClassName("u_")).isEqualTo("U_");
        Assertions.assertThat((String)this.namingStrategy.getClassName("us_")).isEqualTo("Us_");
    }

    @Test
    public void getPropertyName() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("while", this.entityModel)).isEqualTo("whileCol");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("name", this.entityModel)).isEqualTo("name");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("user_id", this.entityModel)).isEqualTo("userId");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("accountEvent_id", this.entityModel)).isEqualTo("accountEventId");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("123abc", this.entityModel)).isEqualTo("_123abc");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("123 abc", this.entityModel)).isEqualTo("_123Abc");
    }

    @Test
    public void getPropertyName_for_column_with_spaces() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("user id", this.entityModel)).isEqualTo("userId");
    }

    @Test
    public void getPropertyNameForInverseForeignKey() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_superior", this.entityModel)).isEqualTo("_superiorFk");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_order_rows", this.entityModel)).isEqualTo("rows");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_category_events", this.entityModel)).isEqualTo("events");
    }

    @Test
    public void getPropertyNameForForeignKey() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("fk_superior", this.entityModel)).isEqualTo("superiorFk");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("FK_SUPERIOR", this.entityModel)).isEqualTo("superiorFk");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("fk_order_rows", this.entityModel)).isEqualTo("order");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("fk_category_events", this.entityModel)).isEqualTo("category");
    }

    @Test
    public void getPropertyNameForPrimaryKey() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForPrimaryKey("pk_superior", this.entityModel)).isEqualTo("superiorPk");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForPrimaryKey("PK_SUPERIOR", this.entityModel)).isEqualTo("superiorPk");
    }

    @Test
    public void getDefaultVariableName() {
        Assertions.assertThat((String)this.namingStrategy.getDefaultVariableName(this.entityModel)).isEqualTo("object");
    }
}

